"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitRecordModifierFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const filter_plugin_base_1 = require("./filter-plugin-base");
/**
 * A Fluent Bit filter that allows appending fields or excluding specific
 * fields.
 */
class FluentBitRecordModifierFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
       * Creates a new instance of the FluentBitRecordModifierFilter class.
       *
       * @param options The configuration options to use for filter.
       */
    constructor(options = {}) {
        super('record_modifier', options);
        this._allow = [];
        this._records = [];
        this._remove = [];
        options.allow?.forEach((x) => {
            this.addAllow(x);
        });
        options.records?.forEach((x) => {
            this.addRecord(x);
        });
        options.remove?.forEach((x) => {
            this.addRemove(x);
        });
    }
    /**
       * Collection of tags that are allowed on a matched input record.
       *
       * If a tag is not matched it is removed.
       */
    get allow() {
        return [...this._allow];
    }
    /**
       * Collection of the records to be appending to matched input.
       */
    get records() {
        return [...this._records];
    }
    /**
       * Collection of tags to exclude from a matched input record.
       *
       * If a tag is matched it is removed.
       */
    get remove() {
        return [...this._remove];
    }
    /**
       * Adds a tag to be allowed on a matched input record.
       *
       * If a tag is not matched it is removed.
       *
       * @param tag The tag to add to the allow list
       * @returns The record modifier filter that the tag plugin was registered
       * with.
       */
    addAllow(tag) {
        this._allow.push(tag);
        return this;
    }
    /**
       * Add a record to be appended to matched events.
       *
       * @param record The record to be appended to matched input.
       * @returns The record modifier filter that the tag plugin was registered
       * with.
       */
    addRecord(record) {
        this._records.push(record);
        return this;
    }
    /**
       * Adds a tag to be removed on a matched input record.
       *
       * If a tag is matched it is removed.
       *
       * @param tag The tag to add to the allow list
       * @returns The record modifier filter that the tag plugin was registered
       * with.
       */
    addRemove(tag) {
        this._remove.push(tag);
        return this;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        if (this._allow.length === 0 && this._records.length === 0 && this._remove.length === 0) {
            throw new Error([
                'At least one allow, remove, or record rule must be specified',
                'when creating a Fluent Bit record modifier filter.',
            ].join(' '));
        }
        return {
            configFile: this.renderConfigFile({
                Allowlist_key: this.allow,
                Record: this.records.map((x) => {
                    return `${x.fieldName} ${x.value}`;
                }),
                Remove_key: this.remove,
            }),
        };
    }
}
exports.FluentBitRecordModifierFilter = FluentBitRecordModifierFilter;
_a = JSII_RTTI_SYMBOL_1;
FluentBitRecordModifierFilter[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitRecordModifierFilter", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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