"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitRewriteTagFilter = exports.EmitterStorageType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const filter_plugin_base_1 = require("./filter-plugin-base");
/**
 * Define a buffering mechanism for the new records created by the rewrite tag
 * Fluent Bit filter plugin.
 */
class EmitterStorageType {
    /**
       * Creates a new instance of the EmitterStorageType class.
       *
       * @param name The name of the emitter storage type as it should appear in
       * the plugin configuration file.
       */
    constructor(name) {
        this.name = name;
    }
    /**
       * An escape hatch that allows for specifying a custom value for the
       * rewrite tag plugin's `Emitter_Storage.type` field.
       *
       * @param name The name of the buffering type to use.
       * @returns
       */
    static of(name) {
        return new EmitterStorageType(name);
    }
}
exports.EmitterStorageType = EmitterStorageType;
_a = JSII_RTTI_SYMBOL_1;
EmitterStorageType[_a] = { fqn: "cdk-extensions.k8s_aws.EmitterStorageType", version: "0.0.38" };
/**
   * Buffer records on the filesystem.
   *
   * This is recommended if the destination for new records generated might
   * face backpressure due to latency or slow network speeds.
   */
EmitterStorageType.FILESYSTEM = EmitterStorageType.of('filesystem');
/**
   * Buffer records in memory.
   *
   * This is the default behavior.
   */
EmitterStorageType.MEMORY = EmitterStorageType.of('memory');
/**
 * A Fluent Bit filter that allows parsing of fields in event records.
 */
class FluentBitRewriteTagFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
       * Creates a new instance of the FluentBitRewriteTagFilter class.
       *
       * @param options The configuration options to use for filter.
       */
    constructor(options = {}) {
        super(FluentBitRewriteTagFilter.PLUGIN_NAME, options);
        this._rules = [];
        this.emitterMemBufLimit = options.emitterMemBufLimit;
        this.emitterName = options.emitterName ?? 're_emitted';
        this.emitterStorageType = options.emitterStorageType;
        options.rules?.forEach((x) => {
            this.addRule(x);
        });
    }
    /**
       * Collection of rules defining matching criteria and the format of the tag
       * for the matching record.
       *
       * @group Inputs
       */
    get rules() {
        return [...this._rules];
    }
    /**
       * Adds a new rule to apply to matched log entries.
       *
       * @param rule The rule to apply for matched log entries.
       * @returns The parser filter that the parser plugin was registered with.
       */
    addRule(rule) {
        this._rules.push(rule);
        return this;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        if (this._rules.length === 0) {
            throw new Error([
                'At least one rule must be specified when creating a Fluent',
                'Bit rewrite tag filter.',
            ].join(' '));
        }
        return {
            configFile: this.renderConfigFile({
                'Emitter_Mem_Buf_Limit': this.emitterMemBufLimit ? `${this.emitterMemBufLimit?.toMebibytes()}M` : undefined,
                'Emitter_Name': this.emitterName,
                'Emitter_Storage.type': this.emitterStorageType,
                'Rule': this.rules.map((x) => {
                    return `${x.key} ${x.regex} ${x.newTag} ${x.keep}`;
                }),
            }),
        };
    }
}
exports.FluentBitRewriteTagFilter = FluentBitRewriteTagFilter;
_b = JSII_RTTI_SYMBOL_1;
FluentBitRewriteTagFilter[_b] = { fqn: "cdk-extensions.k8s_aws.FluentBitRewriteTagFilter", version: "0.0.38" };
/**
   * The name of the plugin as it will appear in the fluent bit configuration.
   */
FluentBitRewriteTagFilter.PLUGIN_NAME = 'rewrite_tag';
//# sourceMappingURL=data:application/json;base64,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