"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitThrottleFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const filter_plugin_base_1 = require("./filter-plugin-base");
/**
 * A Fluent Bit filter that sets the average *Rate* of messages per *Interval*,
 * based on leaky bucket and sliding window algorithm. In case of overflood,
 * it will leak within certain rate.
 */
class FluentBitThrottleFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
     * Creates a new instance of the FluentBitThrottleFilter class.
     *
     * @param options Options for configuring the filter.
     */
    constructor(options = {}) {
        super('throttle', options);
        this.interval = options.interval ?? aws_cdk_lib_1.Duration.seconds(1);
        this.printStatus = options.printStatus;
        this.rate = options.rate ?? 5;
        this.window = options.window ?? 5;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        return {
            configFile: this.renderConfigFile({
                Interval: `${this.interval.toSeconds()}s`,
                Print_Status: this.printStatus,
                Rate: this.rate,
                Window: this.window,
            }),
        };
    }
}
exports.FluentBitThrottleFilter = FluentBitThrottleFilter;
_a = JSII_RTTI_SYMBOL_1;
FluentBitThrottleFilter[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitThrottleFilter", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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