"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitPlugin = exports.FluentBitPluginType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const types_1 = require("../../../utils/types");
/**
 * The types of Fluent Bit plugins that can be configured.
 */
var FluentBitPluginType;
(function (FluentBitPluginType) {
    /**
       * A plugin that transforms or filters records.
       */
    FluentBitPluginType["FILTER"] = "FILTER";
    /**
       * A plugin that configures where output should be sent.
       */
    FluentBitPluginType["OUTPUT"] = "OUTPUT";
    /**
       * A plugin that read data from input objects into structured objects.
       */
    FluentBitPluginType["PARSER"] = "PARSER";
})(FluentBitPluginType = exports.FluentBitPluginType || (exports.FluentBitPluginType = {}));
/**
 * A Fluent Bit plugin that allows for configuration of options and can be
 * used to configure logging from containers.
 */
class FluentBitPlugin {
    /**
     * Creates a new instance of the FluentBitPlugin class.
     *
     * @param options Configuration options for the plugin.
     */
    constructor(options) {
        this.name = options.name;
        this.pluginType = options.pluginType;
    }
    /**
     *
     * @param config The configuration properties to render into a Fluent Bit
     * configuration file.
     * @returns A fluent bit config file representation of the passed properties.
     */
    renderConfigFile(config) {
        const fullConfig = {
            Name: this.name,
            ...config,
        };
        return Object.keys(fullConfig).reduce((prev, cur) => {
            const val = fullConfig[cur];
            const arr = types_1.isArray(val) ? val : [val];
            arr.filter((x) => {
                return x !== undefined;
            }).forEach((x) => {
                prev.push(`    ${cur} ${x}`);
            });
            return prev;
        }, [`[${this.pluginType}]`]).join('\n');
    }
}
exports.FluentBitPlugin = FluentBitPlugin;
_a = JSII_RTTI_SYMBOL_1;
FluentBitPlugin[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitPlugin", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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