"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitMatch = exports.FluentBitMatchEvaluator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Matching patterns supported by Fluent Bit plugins for scoping down incoming
 * records.
 */
var FluentBitMatchEvaluator;
(function (FluentBitMatchEvaluator) {
    /**
       * A basic pattern match supporting the star (`*`) character as a wildcard.
       */
    FluentBitMatchEvaluator["GLOB"] = "Match";
    /**
       * Full pattern matching using regular expressions.
       */
    FluentBitMatchEvaluator["REGEX"] = "Match_Regex";
})(FluentBitMatchEvaluator = exports.FluentBitMatchEvaluator || (exports.FluentBitMatchEvaluator = {}));
/**
 * Represents a filter that can be applied to Filter and Output plugins that
 * scopes down what records the given filter should apply to.
 */
class FluentBitMatch {
    /**
       * Creates a new instance of the FluentBitMatch class.
       *
       * @param evaluator The pattern matching syntax to use when evaluating
       * incoming tags.
       * @param pattern The pattern to compare against the tags of incoming
       * records.
       */
    constructor(evaluator, pattern) {
        this.evaluator = evaluator;
        this.pattern = pattern;
    }
    /**
       * Creates a match pattern that supports basic wildcard matching using the
       * star character (`*`).
       *
       * @param pattern The pattern to use to match against the tags of an
       * incoming record. It's case sensitive and support the star (`*`)
       * character as a wildcard.
       * @returns A match object representing the given pattern.
       */
    static glob(pattern) {
        return new FluentBitMatch(FluentBitMatchEvaluator.GLOB, pattern);
    }
    /**
       * Creates a match pattern that supports full regex matching.
       *
       * @param pattern A regular expression to match against the tags of
       * incoming records.
       * @returns A match object representing the given pattern.
       */
    static regex(pattern) {
        return new FluentBitMatch(FluentBitMatchEvaluator.REGEX, pattern);
    }
    /**
       * Creates a record object that can be used to represent the match in
       * Fluent Bit configuration files.
       *
       * @returns The object that can be used to represent this match object.
       */
    toObject() {
        return {
            [this.evaluator]: this.pattern,
        };
    }
    /**
       * Creates a string representation of this match object that reflects how
       * it will appear in a Fluent Bit configuration file.
       *
       * @returns A string representation of this match.
       */
    toString() {
        return `${this.evaluator} ${this.pattern}`;
    }
}
exports.FluentBitMatch = FluentBitMatch;
_a = JSII_RTTI_SYMBOL_1;
FluentBitMatch[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitMatch", version: "0.0.38" };
/**
   * Represents a pattern that will match all log entries.
   */
FluentBitMatch.ALL = FluentBitMatch.glob('*');
//# sourceMappingURL=data:application/json;base64,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