"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitCustomOutputPlugin = void 0;
const _1 = require(".");
/**
 * A Fluent Bit plugin that allows for configuration of options and can be
 * used to configure logging from containers.
 */
class FluentBitCustomOutputPlugin extends _1.FluentBitOutputPluginBase {
    /**
       * Creates a new instance of the FluentBitCustomOutputPlugin class.
       *
       * @param options Configuration options for the plugin.
       */
    constructor(options) {
        super(options.name);
        this._fields = {};
    }
    /**
       * Collection of all the fields to be added to the Fluent Bit
       * configuration.
       */
    get fields() {
        return Object.keys(this._fields).reduce((prev, cur) => {
            prev[cur] = this._fields[cur].map((x) => {
                return String(x);
            });
            return prev;
        }, {});
    }
    /**
        * Adds a new field to the Fluent Bit service configuration.
        *
        * @param key The name of the property being set.
        * @param values The values of the property being set.
        * @returns The Fluent Bit plugin configuration where the property was
        * added.
        */
    addField(key, ...values) {
        if (key in this._fields) {
            this._fields[key].concat(values);
        }
        else {
            this._fields[key] = [...values];
        }
        return this;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        return {
            configFile: this.renderConfigFile(this._fields),
        };
    }
}
exports.FluentBitCustomOutputPlugin = FluentBitCustomOutputPlugin;
//# sourceMappingURL=data:application/json;base64,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