"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitElasticsearchOutput = exports.ElasticsearchOutputBufferSize = exports.ElasticsearchCompressionFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("../utils");
const output_plugin_base_1 = require("./output-plugin-base");
var ElasticsearchCompressionFormat;
(function (ElasticsearchCompressionFormat) {
    /**
       * Gzip compression format.
       */
    ElasticsearchCompressionFormat["GZIP"] = "gzip";
})(ElasticsearchCompressionFormat = exports.ElasticsearchCompressionFormat || (exports.ElasticsearchCompressionFormat = {}));
/**
 * Represents the size of the Elasticsearch output buffer to be used by Fluent
 * Bit.
 */
class ElasticsearchOutputBufferSize {
    /**
       *
       * @param value The value to use for the Elasticsearch buffer output
       * property.
       */
    constructor(value) {
        this.value = value;
    }
    /**
       * Set the output buffer to a specified data size.
       *
       * @param size The size of the output buffer.
       * @returns An output buffer size object representing the specified buffer
       * size.
       */
    static bytes(size) {
        return ElasticsearchOutputBufferSize.of(size.toBytes().toString());
    }
    /**
       * An escape hatch that allows an arbitrary value to be set for the
       * Elasticsearch buffer output property.
       *
       * @param value The value to use for the Elasticsearch buffer output
       * property.
       * @returns A `ElasticsearchOutputBufferSize` object representing the
       * passed value.
       */
    static of(value) {
        return new ElasticsearchOutputBufferSize(value);
    }
}
exports.ElasticsearchOutputBufferSize = ElasticsearchOutputBufferSize;
_a = JSII_RTTI_SYMBOL_1;
ElasticsearchOutputBufferSize[_a] = { fqn: "cdk-extensions.k8s_aws.ElasticsearchOutputBufferSize", version: "0.0.38" };
/**
   * Set the output buffer size to unlimited.
   */
ElasticsearchOutputBufferSize.UNLIMITED = ElasticsearchOutputBufferSize.of('False');
class FluentBitElasticsearchOutput extends output_plugin_base_1.FluentBitOutputPluginBase {
    /**
      * Creates a new instance of the FluentBitKinesisFirehoseOutput class.
      *
      * @param options Options for configuring the output.
      */
    constructor(options) {
        super('es', options);
        this.awsAuth = options.awsAuth;
        this.awsExternalId = options.awsExternalId;
        this.awsRegion = options.awsRegion;
        this.awsRole = options.awsRole;
        this.awsStsEndpoint = options.awsStsEndpoint;
        this.bufferSize = options.bufferSize;
        this.cloudAuth = options.cloudAuth;
        this.cloudId = options.cloudId;
        this.compress = options.compress;
        this.currentTimeIndex = options.currentTimeIndex;
        this.generateId = options.generateId;
        this.host = options.host;
        this.httpPasswd = options.httpPasswd;
        this.httpUser = options.httpUser;
        this.idKey = options.idKey;
        this.includeTagKey = options.includeTagKey;
        this.index = options.index;
        this.logstashDateFormat = options.logstashDateFormat;
        this.logstashFormat = options.logstashFormat;
        this.logstashPrefix = options.logstashPrefix;
        this.logstashPrefixKey = options.logstashPrefixKey;
        this.path = options.path;
        this.pipeline = options.pipeline;
        this.port = options.port ?? 9200;
        this.replaceDots = options.replaceDots;
        this.suppressTypeName = options.suppressTypeName;
        this.tagKey = options.tagKey;
        this.timeKey = options.timeKey;
        this.timeKeyFormat = options.timeKeyFormat;
        this.timeKeyNanos = options.timeKeyNanos;
        this.traceError = options.traceError;
        this.traceOutput = options.traceOutput;
        this.type = options.type;
        this.workers = options.workers;
        this.writeOperation = options.writeOperation;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        return {
            configFile: super.renderConfigFile({
                AWS_Auth: utils_1.convertBool(this.awsAuth),
                AWS_External_ID: this.awsExternalId,
                AWS_Region: this.awsRegion,
                AWS_Role_ARN: this.awsRole?.roleArn,
                AWS_STS_Endpoint: this.awsStsEndpoint,
                Buffer_Size: this.bufferSize?.value,
                compress: this.compress,
                Cloud_Auth: this.cloudAuth,
                Cloud_ID: this.cloudId,
                Current_Time_Index: utils_1.convertBool(this.currentTimeIndex),
                Generate_ID: this.generateId,
                Host: this.host,
                HTTP_Passwd: this.httpPasswd,
                HTTP_User: this.httpUser,
                Id_Key: this.idKey,
                Include_Tag_Key: utils_1.convertBool(this.includeTagKey),
                Index: this.index,
                Logstash_DateFormat: this.logstashDateFormat,
                Logstash_Format: utils_1.convertBool(this.logstashFormat),
                Logstash_Prefix: this.logstashPrefix,
                Logstash_Prefix_Key: this.logstashPrefixKey,
                Path: this.path,
                Pipeline: this.pipeline,
                Port: this.port,
                Replace_Dots: utils_1.convertBool(this.replaceDots),
                Suppress_Type_Name: utils_1.convertBool(this.suppressTypeName),
                Tag_Key: this.tagKey,
                Time_Key: this.timeKey,
                Time_Key_Format: this.timeKeyFormat,
                Time_Key_Nanos: utils_1.convertBool(this.timeKeyNanos),
                Trace_Error: utils_1.convertBool(this.traceOutput),
                Trace_Output: utils_1.convertBool(this.traceOutput),
                Type: this.type,
                Workers: this.workers,
                Write_Operation: this.writeOperation,
            }),
        };
    }
}
exports.FluentBitElasticsearchOutput = FluentBitElasticsearchOutput;
_b = JSII_RTTI_SYMBOL_1;
FluentBitElasticsearchOutput[_b] = { fqn: "cdk-extensions.k8s_aws.FluentBitElasticsearchOutput", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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