import { IRole } from 'aws-cdk-lib/aws-iam';
import { IConstruct } from 'constructs';
import { IDeliveryStream } from '../../../../kinesis-firehose';
import { ResolvedFluentBitConfiguration } from '../resolved-fluent-bit-configuration';
import { FluentBitOutputPluginBase, FluentBitOutputPluginCommonOptions } from './output-plugin-base';
export declare enum KinesisFirehoseCompressionFormat {
    /**
       * The Apache Arrow compression format.
       *
       * Only available if the Fluent Fit service being used to send logs to
       * Firehose had Apache Arrow enabled at compile time.
       */
    ARROW = "arrow",
    /**
       * Gzip compression format.
       */
    GZIP = "gzip"
}
/**
 * Options for configuring the Kinesis Firehose Fluent Bit output plugin.
 *
 * @see [Kinesis Firehose Plugin Documention](https://docs.fluentbit.io/manual/pipeline/outputs/firehose)
 */
export interface FluentBitKinesisFirehoseOutputOptions extends FluentBitOutputPluginCommonOptions {
    /**
       * Immediately retry failed requests to AWS services once. This option does
       * not affect the normal Fluent Bit retry mechanism with backoff. Instead,
       * it enables an immediate retry with no delay for networking errors, which
       * may help improve throughput when there are transient/random networking
       * issues.
       *
       * @default true
       */
    readonly autoRetryRequests?: boolean;
    /**
       * Compression type for Firehose records. Each log record is individually
       * compressed and sent to Firehose.
       */
    readonly compression?: KinesisFirehoseCompressionFormat;
    /**
       * The Kinesis Firehose Delivery stream that you want log records sent to.
       */
    readonly deliveryStream?: IDeliveryStream;
    /**
       * Specify a custom endpoint for the Firehose API.
       */
    readonly endpoint?: string;
    /**
       * By default, the whole log record will be sent to Firehose. If you
       * specify a key name with this option, then only the value of that key
       * will be sent to Firehose.
       */
    readonly logKey?: string;
    /**
       * The AWS region.
       */
    readonly region?: string;
    /**
       * ARN of an IAM role to assume (for cross account access).
       */
    readonly role?: IRole;
    /**
       * Specify a custom STS endpoint for the AWS STS API.
       */
    readonly stsEndpoint?: string;
    /**
       * Add the timestamp to the record under this key.
       */
    readonly timeKey?: string;
    /**
       * A strftime compliant format string for the timestamp.
       *
       * @default '%Y-%m-%dT%H:%M:%S'
       */
    readonly timeKeyFormat?: string;
}
/**
 * Represents configuration for outputing logs from Fluent Bit to Kinesis
 * Firehose.
 */
export declare class FluentBitKinesisFirehoseOutput extends FluentBitOutputPluginBase {
    /**
       * Immediately retry failed requests to AWS services once. This option does
       * not affect the normal Fluent Bit retry mechanism with backoff. Instead,
       * it enables an immediate retry with no delay for networking errors, which
       * may help improve throughput when there are transient/random networking
       * issues.
       *
       * @group Inputs
       */
    readonly autoRetryRequests?: boolean;
    /**
       * Compression type for Firehose records. Each log record is individually
       * compressed and sent to Firehose.
       *
       * @group Inputs
       */
    readonly compression?: KinesisFirehoseCompressionFormat;
    /**
       * The Kinesis Firehose Delivery stream that you want log records sent to.
       *
       * @group Inputs
       */
    readonly deliveryStream?: IDeliveryStream;
    /**
       * Specify a custom endpoint for the Firehose API.
       *
       * @group Inputs
       */
    readonly endpoint?: string;
    /**
       * By default, the whole log record will be sent to Firehose. If you
       * specify a key name with this option, then only the value of that key
       * will be sent to Firehose.
       *
       * @group Inputs
       */
    readonly logKey?: string;
    /**
       * The AWS region.
       *
       * @group Inputs
       */
    readonly region?: string;
    /**
       * ARN of an IAM role to assume (for cross account access).
       *
       * @group Inputs
       */
    readonly role?: IRole;
    /**
       * Specify a custom STS endpoint for the AWS STS API.
       *
       * @group Inputs
       */
    readonly stsEndpoint?: string;
    /**
       * Add the timestamp to the record under this key.
       *
       * @group Inputs
       */
    readonly timeKey?: string;
    /**
       * A strftime compliant format string for the timestamp.
       *
       * @group Inputs
       */
    readonly timeKeyFormat?: string;
    /**
      * Creates a new instance of the FluentBitKinesisFirehoseOutput class.
      *
      * @param options Options for configuring the output.
      */
    constructor(options?: FluentBitKinesisFirehoseOutputOptions);
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(scope: IConstruct): ResolvedFluentBitConfiguration;
    /**
       * Gets a delivery stream object that can be used to set the required
       * delivery_stream property if one hasn't been provided.
       *
       * @param scope The construct configuring logging using Fluent Bit.
       * @returns The delivery stream where output logs should be sent.
       */
    private getDeliveryStream;
}
