"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitKinesisFirehoseOutput = exports.KinesisFirehoseCompressionFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const kinesis_firehose_1 = require("../../../../kinesis-firehose");
const output_plugin_base_1 = require("./output-plugin-base");
var KinesisFirehoseCompressionFormat;
(function (KinesisFirehoseCompressionFormat) {
    /**
       * The Apache Arrow compression format.
       *
       * Only available if the Fluent Fit service being used to send logs to
       * Firehose had Apache Arrow enabled at compile time.
       */
    KinesisFirehoseCompressionFormat["ARROW"] = "arrow";
    /**
       * Gzip compression format.
       */
    KinesisFirehoseCompressionFormat["GZIP"] = "gzip";
})(KinesisFirehoseCompressionFormat = exports.KinesisFirehoseCompressionFormat || (exports.KinesisFirehoseCompressionFormat = {}));
/**
 * Represents configuration for outputing logs from Fluent Bit to Kinesis
 * Firehose.
 */
class FluentBitKinesisFirehoseOutput extends output_plugin_base_1.FluentBitOutputPluginBase {
    /**
      * Creates a new instance of the FluentBitKinesisFirehoseOutput class.
      *
      * @param options Options for configuring the output.
      */
    constructor(options = {}) {
        super('kinesis_firehose', options);
        this.autoRetryRequests = options.autoRetryRequests;
        this.compression = options.compression;
        this.deliveryStream = options.deliveryStream;
        this.endpoint = options.endpoint;
        this.logKey = options.logKey;
        this.region = options.region;
        this.role = options.role;
        this.stsEndpoint = options.stsEndpoint;
        this.timeKey = options.timeKey;
        this.timeKeyFormat = options.timeKeyFormat;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(scope) {
        const deliveryStream = this.getDeliveryStream(scope);
        return {
            configFile: super.renderConfigFile({
                auto_retry_requests: this.autoRetryRequests,
                compression: this.compression,
                delivery_stream: deliveryStream.deliveryStreamName,
                endpoint: this.endpoint,
                log_key: this.logKey,
                region: this.region ?? aws_cdk_lib_1.Stack.of(scope).region,
                role_arn: this.role?.roleArn,
                sts_endpoint: this.stsEndpoint,
                time_key: this.timeKey,
                time_key_format: this.timeKeyFormat,
            }),
            permissions: [
                new aws_iam_1.PolicyStatement({
                    actions: [
                        'firehose:PutRecordBatch',
                    ],
                    effect: aws_iam_1.Effect.ALLOW,
                    resources: [
                        deliveryStream.deliveryStreamArn,
                    ],
                }),
            ],
        };
    }
    /**
       * Gets a delivery stream object that can be used to set the required
       * delivery_stream property if one hasn't been provided.
       *
       * @param scope The construct configuring logging using Fluent Bit.
       * @returns The delivery stream where output logs should be sent.
       */
    getDeliveryStream(scope) {
        const deliveryStreamId = 'fluent-bit-output-delivery-stream';
        const bucketId = 'fluent-bit-output-delivery-stream-bucket';
        const inheritedDeliveryStream = scope.node.tryFindChild(deliveryStreamId);
        if (this.deliveryStream) {
            return this.deliveryStream;
        }
        else if (inheritedDeliveryStream) {
            return inheritedDeliveryStream;
        }
        else {
            const bucket = scope.node.tryFindChild(bucketId) ?? new aws_s3_1.Bucket(scope, bucketId, {
                blockPublicAccess: {
                    blockPublicAcls: true,
                    blockPublicPolicy: true,
                    ignorePublicAcls: true,
                    restrictPublicBuckets: true,
                },
                lifecycleRules: [
                    {
                        enabled: true,
                        expiration: aws_cdk_lib_1.Duration.days(365 * 7),
                        noncurrentVersionExpiration: aws_cdk_lib_1.Duration.days(7),
                        transitions: [
                            {
                                storageClass: aws_s3_1.StorageClass.GLACIER,
                                transitionAfter: aws_cdk_lib_1.Duration.days(365 * 1),
                            },
                            {
                                storageClass: aws_s3_1.StorageClass.DEEP_ARCHIVE,
                                transitionAfter: aws_cdk_lib_1.Duration.days(365 * 3),
                            },
                        ],
                    },
                ],
                encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
                versioned: true,
            });
            return new kinesis_firehose_1.DeliveryStream(scope, deliveryStreamId, {
                destination: new kinesis_firehose_1.ExtendedS3Destination(bucket),
            });
        }
    }
}
exports.FluentBitKinesisFirehoseOutput = FluentBitKinesisFirehoseOutput;
_a = JSII_RTTI_SYMBOL_1;
FluentBitKinesisFirehoseOutput[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitKinesisFirehoseOutput", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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