"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitKinesisOutput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_kinesis_1 = require("aws-cdk-lib/aws-kinesis");
const output_plugin_base_1 = require("./output-plugin-base");
/**
 * Represents configuration for outputing logs from Fluent Bit to Kinesis Data
 * Streams.
 */
class FluentBitKinesisOutput extends output_plugin_base_1.FluentBitOutputPluginBase {
    /**
      * Creates a new instance of the FluentBitKinesisOutput class.
      *
      * @param options Options for configuring the output/
      */
    constructor(options = {}) {
        super('kinesis', options);
        this.autoRetryRequests = options.autoRetryRequests;
        this.endpoint = options.endpoint;
        this.logKey = options.logKey;
        this.region = options.region;
        this.role = options.role;
        this.stream = options.stream;
        this.stsEndpoint = options.stsEndpoint;
        this.timeKey = options.timeKey;
        this.timeKeyFormat = options.timeKeyFormat;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(scope) {
        const stream = this.getStream(scope);
        return {
            configFile: super.renderConfigFile({
                auto_retry_requests: this.autoRetryRequests,
                endpoint: this.endpoint,
                log_key: this.logKey,
                region: this.region ?? aws_cdk_lib_1.Stack.of(scope).region,
                role_arn: this.role?.roleArn,
                stream: stream.streamName,
                sts_endpoint: this.stsEndpoint,
                time_key: this.timeKey,
                time_key_format: this.timeKeyFormat,
            }),
            permissions: [
                new aws_iam_1.PolicyStatement({
                    actions: [
                        'kinesis:PutRecords',
                    ],
                    effect: aws_iam_1.Effect.ALLOW,
                    resources: [
                        stream.streamArn,
                    ],
                }),
            ],
        };
    }
    /**
       * Gets a stream object that can be used to set the required stream
       * property if one hasn';t been provided.
       *
       * @param scope The construct configuring logging using Fluent Bit.
       * @returns The stream where output logs should be sent.
       */
    getStream(scope) {
        const streamId = 'fluent-bit-output-stream';
        const inheritedStream = scope.node.tryFindChild(streamId);
        if (this.stream) {
            return this.stream;
        }
        else if (inheritedStream) {
            return inheritedStream;
        }
        else {
            return new aws_kinesis_1.Stream(scope, streamId);
        }
    }
}
exports.FluentBitKinesisOutput = FluentBitKinesisOutput;
_a = JSII_RTTI_SYMBOL_1;
FluentBitKinesisOutput[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitKinesisOutput", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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