"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitOpenSearchOutput = exports.OpenSearchOutputBufferSize = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const utils_1 = require("../utils");
const output_plugin_base_1 = require("./output-plugin-base");
/**
 * Represents the size of the OpenSeach output buffer to be used by Fluent Bit.
 */
class OpenSearchOutputBufferSize {
    /**
       *
       * @param value The value to use for the OpenSearch buffer output property.
       */
    constructor(value) {
        this.value = value;
    }
    /**
       * Set the output buffer to a specified data size.
       *
       * @param size The size of the output buffer.
       * @returns An output buffer size object representing the specified buffer
       * size.
       */
    static bytes(size) {
        return OpenSearchOutputBufferSize.of(size.toBytes().toString());
    }
    /**
       * An escape hatch that allows an arbitrary value to be set for the
       * OpenSearch buffer output property.
       *
       * @param value The value to use for the OpenSearch buffer output property.
       * @returns A `OpenSearchOutputBufferSize` object representing the passed
       * value.
       */
    static of(value) {
        return new OpenSearchOutputBufferSize(value);
    }
}
exports.OpenSearchOutputBufferSize = OpenSearchOutputBufferSize;
_a = JSII_RTTI_SYMBOL_1;
OpenSearchOutputBufferSize[_a] = { fqn: "cdk-extensions.k8s_aws.OpenSearchOutputBufferSize", version: "0.0.38" };
/**
   * Set the output buffer size to unlimited.
   */
OpenSearchOutputBufferSize.UNLIMITED = OpenSearchOutputBufferSize.of('False');
class FluentBitOpenSearchOutput extends output_plugin_base_1.FluentBitOutputPluginBase {
    /**
      * Creates a new instance of the FluentBitOpenSearchOutput class.
      *
      * @param options Options for configuring the output.
      */
    constructor(options) {
        super('opensearch', options);
        this.awsAuth = options.awsAuth;
        this.awsExternalId = options.awsExternalId;
        this.awsRegion = options.awsRegion;
        this.awsRole = options.awsRole;
        this.awsStsEndpoint = options.awsStsEndpoint;
        this.bufferSize = options.bufferSize;
        this.currentTimeIndex = options.currentTimeIndex;
        this.domain = options.domain;
        this.generateId = options.generateId;
        this.httpPasswd = options.httpPasswd;
        this.httpUser = options.httpUser;
        this.idKey = options.idKey;
        this.includeTagKey = options.includeTagKey;
        this.index = options.index;
        this.logstashDateFormat = options.logstashDateFormat;
        this.logstashFormat = options.logstashFormat;
        this.logstashPrefix = options.logstashPrefix;
        this.logstashPrefixKey = options.logstashPrefixKey;
        this.path = options.path;
        this.pipeline = options.pipeline;
        this.port = options.port ?? 9200;
        this.replaceDots = options.replaceDots;
        this.suppressTypeName = options.suppressTypeName;
        this.tagKey = options.tagKey;
        this.timeKey = options.timeKey;
        this.timeKeyFormat = options.timeKeyFormat;
        this.timeKeyNanos = options.timeKeyNanos;
        this.traceError = options.traceError;
        this.traceOutput = options.traceOutput;
        this.type = options.type;
        this.workers = options.workers;
        this.writeOperation = options.writeOperation;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(scope) {
        return {
            configFile: super.renderConfigFile({
                AWS_Auth: utils_1.convertBool(this.awsAuth),
                AWS_External_ID: this.awsExternalId,
                AWS_Region: this.awsRegion ?? aws_cdk_lib_1.Stack.of(scope).region,
                AWS_Role_ARN: this.awsRole?.roleArn,
                AWS_STS_Endpoint: this.awsStsEndpoint,
                Buffer_Size: this.bufferSize?.value,
                Current_Time_Index: utils_1.convertBool(this.currentTimeIndex),
                Generate_ID: utils_1.convertBool(this.generateId),
                Host: this.domain.domainEndpoint,
                HTTP_Passwd: this.httpPasswd,
                HTTP_User: this.httpUser,
                Id_Key: this.idKey,
                Include_Tag_Key: this.includeTagKey,
                Index: this.index,
                Logstash_DateFormat: this.logstashDateFormat,
                Logstash_Format: utils_1.convertBool(this.logstashFormat),
                Logstash_Prefix: this.logstashPrefix,
                Logstash_Prefix_Key: this.logstashPrefixKey,
                Path: this.path,
                Pipeline: this.pipeline,
                Port: this.port,
                Replace_Dots: utils_1.convertBool(this.replaceDots),
                Suppress_Type_Name: utils_1.convertBool(this.suppressTypeName),
                Tag_Key: this.tagKey,
                Time_Key: this.timeKey,
                Time_Key_Format: this.timeKeyFormat,
                Time_Key_Nanos: utils_1.convertBool(this.timeKeyNanos),
                Trace_Error: utils_1.convertBool(this.traceError),
                Trace_Output: utils_1.convertBool(this.traceOutput),
                Type: this.type,
                Workers: this.workers,
                Write_Operation: this.writeOperation,
            }),
        };
    }
}
exports.FluentBitOpenSearchOutput = FluentBitOpenSearchOutput;
_b = JSII_RTTI_SYMBOL_1;
FluentBitOpenSearchOutput[_b] = { fqn: "cdk-extensions.k8s_aws.FluentBitOpenSearchOutput", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3BlbnNlYXJjaC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9rOHMtYXdzL2xpYi9mbHVlbnQtYml0L291dHB1dHMvb3BlbnNlYXJjaC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFvQztBQU1wQyxvQ0FBdUM7QUFDdkMsNkRBQXFHO0FBR3JHOztHQUVHO0FBQ0gsTUFBYSwwQkFBMEI7SUFtQ3JDOzs7U0FHSztJQUNMLFlBQW9CLEtBQWE7UUFDL0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQW5DRDs7Ozs7O1NBTUs7SUFDRSxNQUFNLENBQUMsS0FBSyxDQUFDLElBQWM7UUFDaEMsT0FBTywwQkFBMEIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUVEOzs7Ozs7O1NBT0s7SUFDRSxNQUFNLENBQUMsRUFBRSxDQUFDLEtBQWE7UUFDNUIsT0FBTyxJQUFJLDBCQUEwQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQy9DLENBQUM7O0FBM0JILGdFQTBDQzs7O0FBekNDOztLQUVLO0FBQ2tCLG9DQUFTLEdBQStCLDBCQUEwQixDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsQ0FBQztBQXdSeEcsTUFBYSx5QkFBMEIsU0FBUSw4Q0FBeUI7SUFpUXRFOzs7O1FBSUk7SUFDSixZQUFtQixPQUF5QztRQUMxRCxLQUFLLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRTdCLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsYUFBYSxHQUFHLE9BQU8sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsY0FBYyxHQUFHLE9BQU8sQ0FBQyxjQUFjLENBQUM7UUFDN0MsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxPQUFPLENBQUMsZ0JBQWdCLENBQUM7UUFDakQsSUFBSSxDQUFDLE1BQU0sR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLFFBQVEsR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxLQUFLLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQztRQUMzQixJQUFJLENBQUMsYUFBYSxHQUFHLE9BQU8sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLEtBQUssR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxPQUFPLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLGNBQWMsR0FBRyxPQUFPLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQyxjQUFjLEdBQUcsT0FBTyxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsT0FBTyxDQUFDLGlCQUFpQixDQUFDO1FBQ25ELElBQUksQ0FBQyxJQUFJLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsUUFBUSxHQUFHLE9BQU8sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLElBQUksR0FBRyxPQUFPLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQztRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLE9BQU8sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUM7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxhQUFhLEdBQUcsT0FBTyxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsWUFBWSxHQUFHLE9BQU8sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxXQUFXLEdBQUcsT0FBTyxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsSUFBSSxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxjQUFjLEdBQUcsT0FBTyxDQUFDLGNBQWMsQ0FBQztJQUMvQyxDQUFDO0lBRUQ7Ozs7Ozs7U0FPSztJQUNFLElBQUksQ0FBQyxLQUFpQjtRQUMzQixPQUFPO1lBQ0wsVUFBVSxFQUFFLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDakMsUUFBUSxFQUFFLG1CQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztnQkFDbkMsZUFBZSxFQUFFLElBQUksQ0FBQyxhQUFhO2dCQUNuQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFNBQVMsSUFBSSxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNO2dCQUNwRCxZQUFZLEVBQUUsSUFBSSxDQUFDLE9BQU8sRUFBRSxPQUFPO2dCQUNuQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsY0FBYztnQkFDckMsV0FBVyxFQUFFLElBQUksQ0FBQyxVQUFVLEVBQUUsS0FBSztnQkFDbkMsa0JBQWtCLEVBQUUsbUJBQVcsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7Z0JBQ3RELFdBQVcsRUFBRSxtQkFBVyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7Z0JBQ3pDLElBQUksRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWM7Z0JBQ2hDLFdBQVcsRUFBRSxJQUFJLENBQUMsVUFBVTtnQkFDNUIsU0FBUyxFQUFFLElBQUksQ0FBQyxRQUFRO2dCQUN4QixNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUs7Z0JBQ2xCLGVBQWUsRUFBRSxJQUFJLENBQUMsYUFBYTtnQkFDbkMsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLO2dCQUNqQixtQkFBbUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCO2dCQUM1QyxlQUFlLEVBQUUsbUJBQVcsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO2dCQUNqRCxlQUFlLEVBQUUsSUFBSSxDQUFDLGNBQWM7Z0JBQ3BDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7Z0JBQzNDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtnQkFDZixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7Z0JBQ3ZCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtnQkFDZixZQUFZLEVBQUUsbUJBQVcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO2dCQUMzQyxrQkFBa0IsRUFBRSxtQkFBVyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDdEQsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNO2dCQUNwQixRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU87Z0JBQ3RCLGVBQWUsRUFBRSxJQUFJLENBQUMsYUFBYTtnQkFDbkMsY0FBYyxFQUFFLG1CQUFXLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztnQkFDOUMsV0FBVyxFQUFFLG1CQUFXLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztnQkFDekMsWUFBWSxFQUFFLG1CQUFXLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztnQkFDM0MsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO2dCQUNmLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztnQkFDckIsZUFBZSxFQUFFLElBQUksQ0FBQyxjQUFjO2FBQ3JDLENBQUM7U0FDSCxDQUFDO0lBQ0osQ0FBQzs7QUF4VkgsOERBeVZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBJUm9sZSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgSURvbWFpbiB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1vcGVuc2VhcmNoc2VydmljZSc7XG5pbXBvcnQgeyBJQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBEYXRhU2l6ZSB9IGZyb20gJy4uLy4uLy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgUmVzb2x2ZWRGbHVlbnRCaXRDb25maWd1cmF0aW9uIH0gZnJvbSAnLi4vcmVzb2x2ZWQtZmx1ZW50LWJpdC1jb25maWd1cmF0aW9uJztcbmltcG9ydCB7IGNvbnZlcnRCb29sIH0gZnJvbSAnLi4vdXRpbHMnO1xuaW1wb3J0IHsgRmx1ZW50Qml0T3V0cHV0UGx1Z2luQmFzZSwgRmx1ZW50Qml0T3V0cHV0UGx1Z2luQ29tbW9uT3B0aW9ucyB9IGZyb20gJy4vb3V0cHV0LXBsdWdpbi1iYXNlJztcblxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIHNpemUgb2YgdGhlIE9wZW5TZWFjaCBvdXRwdXQgYnVmZmVyIHRvIGJlIHVzZWQgYnkgRmx1ZW50IEJpdC5cbiAqL1xuZXhwb3J0IGNsYXNzIE9wZW5TZWFyY2hPdXRwdXRCdWZmZXJTaXplIHtcbiAgLyoqXG4gICAgICogU2V0IHRoZSBvdXRwdXQgYnVmZmVyIHNpemUgdG8gdW5saW1pdGVkLlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFVOTElNSVRFRDogT3BlblNlYXJjaE91dHB1dEJ1ZmZlclNpemUgPSBPcGVuU2VhcmNoT3V0cHV0QnVmZmVyU2l6ZS5vZignRmFsc2UnKTtcblxuICAvKipcbiAgICAgKiBTZXQgdGhlIG91dHB1dCBidWZmZXIgdG8gYSBzcGVjaWZpZWQgZGF0YSBzaXplLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNpemUgVGhlIHNpemUgb2YgdGhlIG91dHB1dCBidWZmZXIuXG4gICAgICogQHJldHVybnMgQW4gb3V0cHV0IGJ1ZmZlciBzaXplIG9iamVjdCByZXByZXNlbnRpbmcgdGhlIHNwZWNpZmllZCBidWZmZXJcbiAgICAgKiBzaXplLlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGJ5dGVzKHNpemU6IERhdGFTaXplKTogT3BlblNlYXJjaE91dHB1dEJ1ZmZlclNpemUge1xuICAgIHJldHVybiBPcGVuU2VhcmNoT3V0cHV0QnVmZmVyU2l6ZS5vZihzaXplLnRvQnl0ZXMoKS50b1N0cmluZygpKTtcbiAgfVxuXG4gIC8qKlxuICAgICAqIEFuIGVzY2FwZSBoYXRjaCB0aGF0IGFsbG93cyBhbiBhcmJpdHJhcnkgdmFsdWUgdG8gYmUgc2V0IGZvciB0aGVcbiAgICAgKiBPcGVuU2VhcmNoIGJ1ZmZlciBvdXRwdXQgcHJvcGVydHkuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gdmFsdWUgVGhlIHZhbHVlIHRvIHVzZSBmb3IgdGhlIE9wZW5TZWFyY2ggYnVmZmVyIG91dHB1dCBwcm9wZXJ0eS5cbiAgICAgKiBAcmV0dXJucyBBIGBPcGVuU2VhcmNoT3V0cHV0QnVmZmVyU2l6ZWAgb2JqZWN0IHJlcHJlc2VudGluZyB0aGUgcGFzc2VkXG4gICAgICogdmFsdWUuXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YodmFsdWU6IHN0cmluZyk6IE9wZW5TZWFyY2hPdXRwdXRCdWZmZXJTaXplIHtcbiAgICByZXR1cm4gbmV3IE9wZW5TZWFyY2hPdXRwdXRCdWZmZXJTaXplKHZhbHVlKTtcbiAgfVxuXG5cbiAgLyoqXG4gICAgICogVGhlIHZhbHVlIHRvIHVzZSBmb3IgdGhlIE9wZW5TZWFyY2ggYnVmZmVyIG91dHB1dCBwcm9wZXJ0eS5cbiAgICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZhbHVlOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICpcbiAgICAgKiBAcGFyYW0gdmFsdWUgVGhlIHZhbHVlIHRvIHVzZSBmb3IgdGhlIE9wZW5TZWFyY2ggYnVmZmVyIG91dHB1dCBwcm9wZXJ0eS5cbiAgICAgKi9cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy52YWx1ZSA9IHZhbHVlO1xuICB9XG59XG5cblxuLyoqXG4gKiBPcHRpb25zIGZvciBjb25maWd1cmluZyB0aGUgT3BlblNlYXJjaCBGbHVlbnQgQml0IG91dHB1dCBwbHVnaW4uXG4gKlxuICogQHNlZSBbT3BlblNlYXJjaCBQbHVnaW4gRG9jdW1lbnRpb25dKGh0dHBzOi8vZG9jcy5mbHVlbnRiaXQuaW8vbWFudWFsL3BpcGVsaW5lL291dHB1dHMvb3BlbnNlYXJjaClcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBGbHVlbnRCaXRPcGVuU2VhcmNoT3V0cHV0T3B0aW9ucyBleHRlbmRzIEZsdWVudEJpdE91dHB1dFBsdWdpbkNvbW1vbk9wdGlvbnMge1xuICAvKipcbiAgICAgKiBFbmFibGUgQVdTIFNpZ3Y0IEF1dGhlbnRpY2F0aW9uIGZvciBBbWF6b24gT3BlblNlYXJjaCBTZXJ2aWNlLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgZmFsc2VcbiAgICAgKi9cbiAgcmVhZG9ubHkgYXdzQXV0aD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAgICogRXh0ZXJuYWwgSUQgZm9yIHRoZSBBV1MgSUFNIFJvbGUgc3BlY2lmaWVkIHdpdGggYGF3c1JvbGVgLlxuICAgICAqL1xuICByZWFkb25seSBhd3NFeHRlcm5hbElkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFNwZWNpZnkgdGhlIEFXUyByZWdpb24gZm9yIEFtYXpvbiBPcGVuU2VhcmNoIFNlcnZpY2UuXG4gICAgICovXG4gIHJlYWRvbmx5IGF3c1JlZ2lvbj86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBBV1MgSUFNIFJvbGUgdG8gYXNzdW1lIHRvIHB1dCByZWNvcmRzIHRvIHlvdXIgQW1hem9uIGNsdXN0ZXIuXG4gICAgICovXG4gIHJlYWRvbmx5IGF3c1JvbGU/OiBJUm9sZTtcblxuICAvKipcbiAgICAgKiBTcGVjaWZ5IHRoZSBjdXN0b20gc3RzIGVuZHBvaW50IHRvIGJlIHVzZWQgd2l0aCBTVFMgQVBJIGZvciBBbWF6b25cbiAgICAgKiBPcGVuU2VhcmNoIFNlcnZpY2UuXG4gICAgICovXG4gIHJlYWRvbmx5IGF3c1N0c0VuZHBvaW50Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFNwZWNpZnkgdGhlIGJ1ZmZlciBzaXplIHVzZWQgdG8gcmVhZCB0aGUgcmVzcG9uc2UgZnJvbSB0aGUgT3BlblNlYXJjaFxuICAgICAqIEhUVFAgc2VydmljZS4gVGhpcyBvcHRpb24gaXMgdXNlZnVsIGZvciBkZWJ1Z2dpbmcgcHVycG9zZXMgd2hlcmUgaXNcbiAgICAgKiByZXF1aXJlZCB0byByZWFkIGZ1bGwgcmVzcG9uc2VzLCBub3RlIHRoYXQgcmVzcG9uc2Ugc2l6ZSBncm93cyBkZXBlbmRpbmdcbiAgICAgKiBvZiB0aGUgbnVtYmVyIG9mIHJlY29yZHMgaW5zZXJ0ZWQuXG4gICAgICovXG4gIHJlYWRvbmx5IGJ1ZmZlclNpemU/OiBPcGVuU2VhcmNoT3V0cHV0QnVmZmVyU2l6ZTtcblxuICAvKipcbiAgICAgKiBVc2UgY3VycmVudCB0aW1lIGZvciBpbmRleCBnZW5lcmF0aW9uIGluc3RlYWQgb2YgbWVzc2FnZSByZWNvcmQuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgICAqL1xuICByZWFkb25seSBjdXJyZW50VGltZUluZGV4PzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBUaGUgT3BlbnNlYXJjaCBkb21haW4gdG8gd2hpY2ggbG9ncyBzaG91bGQgYmUgc2hpcHBlZC5cbiAgICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluOiBJRG9tYWluO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gZW5hYmxlZCwgZ2VuZXJhdGUgYF9pZGAgZm9yIG91dGdvaW5nIHJlY29yZHMuIFRoaXMgcHJldmVudHMgZHVwbGljYXRlXG4gICAgICogcmVjb3JkcyB3aGVuIHJldHJ5aW5nLlxuICAgICAqL1xuICByZWFkb25seSBnZW5lcmF0ZUlkPzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBJUCBhZGRyZXNzIG9yIGhvc3RuYW1lIG9mIHRoZSB0YXJnZXQgT3BlblNlYXJjaCBpbnN0YW5jZS5cbiAgICAgKi9cbiAgcmVhZG9ubHkgaG9zdD86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBQYXNzd29yZCBmb3IgdXNlciBkZWZpbmVkIGluIGBodHRwVXNlcmAuXG4gICAgICovXG4gIHJlYWRvbmx5IGh0dHBQYXNzd2Q/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogT3B0aW9uYWwgdXNlcm5hbWUgY3JlZGVudGlhbCBmb3IgYWNjZXNzLlxuICAgICAqL1xuICByZWFkb25seSBodHRwVXNlcj86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBJZiBzZXQsIGBfaWRgIHdpbGwgYmUgdGhlIHZhbHVlIG9mIHRoZSBrZXkgZnJvbSBpbmNvbWluZyByZWNvcmQgYW5kXG4gICAgICogYGdlbmVyYXRlSWRgIG9wdGlvbiBpcyBpZ25vcmVkLlxuICAgICAqL1xuICByZWFkb25seSBpZEtleT86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBXaGVuIGVuYWJsZWQsIGl0IGFwcGVuZCB0aGUgVGFnIG5hbWUgdG8gdGhlIHJlY29yZC5cbiAgICAgKi9cbiAgcmVhZG9ubHkgaW5jbHVkZVRhZ0tleT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAgICogSW5kZXggbmFtZS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0ICdmbHVlbnQtYml0XG4gICAgICovXG4gIHJlYWRvbmx5IGluZGV4Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFRpbWUgZm9ybWF0IChiYXNlZCBvbiBzdHJmdGltZSkgdG8gZ2VuZXJhdGUgdGhlIHNlY29uZCBwYXJ0IG9mIHRoZSBJbmRleFxuICAgICAqIG5hbWUuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAnJVkuJW0uJWQnXG4gICAgICpcbiAgICAgKiBAc2VlIFtzdHJmdGltZV0oaHR0cDovL21hbjcub3JnL2xpbnV4L21hbi1wYWdlcy9tYW4zL3N0cmZ0aW1lLjMuaHRtbClcbiAgICAgKi9cbiAgcmVhZG9ubHkgbG9nc3Rhc2hEYXRlRm9ybWF0Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIEVuYWJsZSBMb2dzdGFzaCBmb3JtYXQgY29tcGF0aWJpbGl0eS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGZhbHNlXG4gICAgICovXG4gIHJlYWRvbmx5IGxvZ3N0YXNoRm9ybWF0PzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBXaGVuIGBsb2dzdGFzaEZvcm1hdGAgaXMgZW5hYmxlZCwgdGhlIEluZGV4IG5hbWUgaXMgY29tcG9zZWQgdXNpbmcgYVxuICAgICAqIHByZWZpeCBhbmQgdGhlIGRhdGUsIGUuZzogSWYgYGxvZ3N0YXNoUHJlZml4YCBpcyBlcXVhbHMgdG8gJ215ZGF0YScgeW91clxuICAgICAqIGluZGV4IHdpbGwgYmVjb21lICdteWRhdGEtWVlZWS5NTS5ERCcuXG4gICAgICpcbiAgICAgKiBUaGUgbGFzdCBzdHJpbmcgYXBwZW5kZWQgYmVsb25ncyB0byB0aGUgZGF0ZSB3aGVuIHRoZSBkYXRhIGlzIGJlaW5nXG4gICAgICogZ2VuZXJhdGVkLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgJ2xvZ3N0YXNoJ1xuICAgICAqL1xuICByZWFkb25seSBsb2dzdGFzaFByZWZpeD86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBXaGVuIGluY2x1ZGVkOiB0aGUgdmFsdWUgaW4gdGhlIHJlY29yZCB0aGF0IGJlbG9uZ3MgdG8gdGhlIGtleSB3aWxsIGJlXG4gICAgICogbG9va2VkIHVwIGFuZCBvdmVyLXdyaXRlIHRoZSBgbG9nc3Rhc2hQcmVmaXhgIGZvciBpbmRleCBnZW5lcmF0aW9uLiBJZlxuICAgICAqIHRoZSBrZXkvdmFsdWUgaXMgbm90IGZvdW5kIGluIHRoZSByZWNvcmQgdGhlbiB0aGUgYGxvZ3N0YXNoUHJlZml4YCBvcHRpb25cbiAgICAgKiB3aWxsIGFjdCBhcyBhIGZhbGxiYWNrLlxuICAgICAqXG4gICAgICogTmVzdGVkIGtleXMgYXJlIG5vdCBzdXBwb3J0ZWQgKGlmIGRlc2lyZWQsIHlvdSBjYW4gdXNlIHRoZSBuZXN0IGZpbHRlclxuICAgICAqIHBsdWdpbiB0byByZW1vdmUgbmVzdGluZylcbiAgICAgKi9cbiAgcmVhZG9ubHkgbG9nc3Rhc2hQcmVmaXhLZXk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogT3BlblNlYXJjaCBhY2NlcHRzIG5ldyBkYXRhIG9uIEhUVFAgcXVlcnkgcGF0aCBcIi9fYnVsa1wiLiBCdXQgaXQgaXMgYWxzb1xuICAgICAqIHBvc3NpYmxlIHRvIHNlcnZlIE9wZW5TZWFyY2ggYmVoaW5kIGEgcmV2ZXJzZSBwcm94eSBvbiBhIHN1YnBhdGguIFRoaXNcbiAgICAgKiBvcHRpb24gZGVmaW5lcyBzdWNoIHBhdGggb24gdGhlIGZsdWVudC1iaXQgc2lkZS4gSXQgc2ltcGx5IGFkZHMgYSBwYXRoXG4gICAgICogcHJlZml4IGluIHRoZSBpbmRleGluZyBIVFRQIFBPU1QgVVJJLi5cbiAgICAgKi9cbiAgcmVhZG9ubHkgcGF0aD86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBPcGVuU2VhcmNoIGFsbG93cyB0byBzZXR1cCBmaWx0ZXJzIGNhbGxlZCBwaXBlbGluZXMuIFRoaXMgb3B0aW9uIGFsbG93c1xuICAgICAqIHRvIGRlZmluZSB3aGljaCBwaXBlbGluZSB0aGUgZGF0YWJhc2Ugc2hvdWxkIHVzZS5cbiAgICAgKi9cbiAgcmVhZG9ubHkgcGlwZWxpbmU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogVENQIHBvcnQgb2YgdGhlIHRhcmdldCBPcGVuU2VhcmNoIGluc3RhbmNlLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgOTIwMFxuICAgICAqL1xuICByZWFkb25seSBwb3J0PzogbnVtYmVyO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gZW5hYmxlZCwgcmVwbGFjZSBmaWVsZCBuYW1lIGRvdHMgd2l0aCB1bmRlcnNjb3JlLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgZmFsc2VcbiAgICAgKi9cbiAgcmVhZG9ubHkgcmVwbGFjZURvdHM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gZW5hYmxlZCwgbWFwcGluZyB0eXBlcyBpcyByZW1vdmVkIGFuZCBgdHlwZWAgb3B0aW9uIGlzIGlnbm9yZWQuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgICAqL1xuICByZWFkb25seSBzdXBwcmVzc1R5cGVOYW1lPzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBXaGVuIGBpbmNsdWRlVGFnS2V5YCBpcyBlbmFibGVkLCB0aGlzIHByb3BlcnR5IGRlZmluZXMgdGhlIGtleSBuYW1lIGZvclxuICAgICAqIHRoZSB0YWcuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAnX2ZsYi1rZXknXG4gICAgICovXG4gIHJlYWRvbmx5IHRhZ0tleT86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBXaGVuIGBsb2dzdGFzaEZvcm1hdGAgaXMgZW5hYmxlZCwgZWFjaCByZWNvcmQgd2lsbCBnZXQgYSBuZXcgdGltZXN0YW1wXG4gICAgICogZmllbGQuIFRoZWB0aW1lS2V5YCBwcm9wZXJ0eSBkZWZpbmVzIHRoZSBuYW1lIG9mIHRoYXQgZmllbGQuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAnQHRpbWVzdGFtcCdcbiAgICAgKi9cbiAgcmVhZG9ubHkgdGltZUtleT86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBXaGVuIGBsb2dzdGFzaEZvcm1hdGAgaXMgZW5hYmxlZCwgdGhpcyBwcm9wZXJ0eSBkZWZpbmVzIHRoZSBmb3JtYXQgb2YgdGhlXG4gICAgICogdGltZXN0YW1wLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgJyVZLSVtLSVkVCVIOiVNOiVTJ1xuICAgICAqXG4gICAgICogQHNlZSBbc3RyZnRpbWVdKGh0dHA6Ly9tYW43Lm9yZy9saW51eC9tYW4tcGFnZXMvbWFuMy9zdHJmdGltZS4zLmh0bWwpXG4gICAgICovXG4gIHJlYWRvbmx5IHRpbWVLZXlGb3JtYXQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogV2hlbiBgbG9nc3Rhc2hGb3JtYXRgIGlzIGVuYWJsZWQsIGVuYWJsaW5nIHRoaXMgcHJvcGVydHkgc2VuZHMgbmFub3NlY29uZFxuICAgICAqIHByZWNpc2lvbiB0aW1lc3RhbXBzLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgZmFsc2VcbiAgICAgKi9cbiAgcmVhZG9ubHkgdGltZUtleU5hbm9zPzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBXaGVuIGVuYWJsZWQgcHJpbnQgdGhlIE9wZW5TZWFyY2ggQVBJIGNhbGxzIHRvIHN0ZG91dCB3aGVuIE9wZW5TZWFyY2hcbiAgICAgKiByZXR1cm5zIGFuIGVycm9yIChmb3IgZGlhZyBvbmx5KS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGZhbHNlXG4gICAgICovXG4gIHJlYWRvbmx5IHRyYWNlRXJyb3I/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gZW5hYmxlZCBwcmludCB0aGUgT3BlblNlYXJjaCBBUEkgY2FsbHMgdG8gc3Rkb3V0IChmb3IgZGlhZyBvbmx5KS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGZhbHNlXG4gICAgICovXG4gIHJlYWRvbmx5IHRyYWNlT3V0cHV0PzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBUeXBlIG5hbWUuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAnX2RvYydcbiAgICAgKi9cbiAgcmVhZG9ubHkgdHlwZT86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBFbmFibGVzIGRlZGljYXRlZCB0aHJlYWQocykgZm9yIHRoaXMgb3V0cHV0LlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgMlxuICAgICAqL1xuICByZWFkb25seSB3b3JrZXJzPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgICAqIE9wZXJhdGlvbiB0byB1c2UgdG8gd3JpdGUgaW4gYnVsayByZXF1ZXN0cy5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0ICdjcmVhdGUnXG4gICAgICovXG4gIHJlYWRvbmx5IHdyaXRlT3BlcmF0aW9uPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgRmx1ZW50Qml0T3BlblNlYXJjaE91dHB1dCBleHRlbmRzIEZsdWVudEJpdE91dHB1dFBsdWdpbkJhc2Uge1xuICAvKipcbiAgICAgKiBFbmFibGUgQVdTIFNpZ3Y0IEF1dGhlbnRpY2F0aW9uIGZvciBBbWF6b24gT3BlblNlYXJjaCBTZXJ2aWNlLlxuICAgICAqXG4gICAgICogQGdyb3VwIElucHV0c1xuICAgICAqL1xuICByZWFkb25seSBhd3NBdXRoPzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBFeHRlcm5hbCBJRCBmb3IgdGhlIEFXUyBJQU0gUm9sZSBzcGVjaWZpZWQgd2l0aCBgYXdzUm9sZWAuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IGF3c0V4dGVybmFsSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogU3BlY2lmeSB0aGUgQVdTIHJlZ2lvbiBmb3IgQW1hem9uIE9wZW5TZWFyY2ggU2VydmljZS5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgYXdzUmVnaW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIEFXUyBJQU0gUm9sZSB0byBhc3N1bWUgdG8gcHV0IHJlY29yZHMgdG8geW91ciBBbWF6b24gY2x1c3Rlci5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgYXdzUm9sZT86IElSb2xlO1xuXG4gIC8qKlxuICAgICAqIFNwZWNpZnkgdGhlIGN1c3RvbSBzdHMgZW5kcG9pbnQgdG8gYmUgdXNlZCB3aXRoIFNUUyBBUEkgZm9yIEFtYXpvblxuICAgICAqIE9wZW5TZWFyY2ggU2VydmljZS5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgYXdzU3RzRW5kcG9pbnQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogU3BlY2lmeSB0aGUgYnVmZmVyIHNpemUgdXNlZCB0byByZWFkIHRoZSByZXNwb25zZSBmcm9tIHRoZSBPcGVuU2VhcmNoXG4gICAgICogSFRUUCBzZXJ2aWNlLiBUaGlzIG9wdGlvbiBpcyB1c2VmdWwgZm9yIGRlYnVnZ2luZyBwdXJwb3NlcyB3aGVyZSBpc1xuICAgICAqIHJlcXVpcmVkIHRvIHJlYWQgZnVsbCByZXNwb25zZXMsIG5vdGUgdGhhdCByZXNwb25zZSBzaXplIGdyb3dzIGRlcGVuZGluZ1xuICAgICAqIG9mIHRoZSBudW1iZXIgb2YgcmVjb3JkcyBpbnNlcnRlZC5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgYnVmZmVyU2l6ZT86IE9wZW5TZWFyY2hPdXRwdXRCdWZmZXJTaXplO1xuXG4gIC8qKlxuICAgICAqIFVzZSBjdXJyZW50IHRpbWUgZm9yIGluZGV4IGdlbmVyYXRpb24gaW5zdGVhZCBvZiBtZXNzYWdlIHJlY29yZC5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgY3VycmVudFRpbWVJbmRleD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAgICogVGhlIE9wZW5zZWFyY2ggZG9tYWluIHRvIHdoaWNoIGxvZ3Mgc2hvdWxkIGJlIHNoaXBwZWQuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IGRvbWFpbjogSURvbWFpbjtcblxuICAvKipcbiAgICAgKiBXaGVuIGVuYWJsZWQsIGdlbmVyYXRlIGBfaWRgIGZvciBvdXRnb2luZyByZWNvcmRzLiBUaGlzIHByZXZlbnRzIGR1cGxpY2F0ZVxuICAgICAqIHJlY29yZHMgd2hlbiByZXRyeWluZy5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgZ2VuZXJhdGVJZD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAgICogUGFzc3dvcmQgZm9yIHVzZXIgZGVmaW5lZCBpbiBgaHR0cFVzZXJgLlxuICAgICAqXG4gICAgICogQGdyb3VwIElucHV0c1xuICAgICAqL1xuICByZWFkb25seSBodHRwUGFzc3dkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIE9wdGlvbmFsIHVzZXJuYW1lIGNyZWRlbnRpYWwgZm9yIGFjY2Vzcy5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgaHR0cFVzZXI/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogSWYgc2V0LCBgX2lkYCB3aWxsIGJlIHRoZSB2YWx1ZSBvZiB0aGUga2V5IGZyb20gaW5jb21pbmcgcmVjb3JkIGFuZFxuICAgICAqIGBnZW5lcmF0ZUlkYCBvcHRpb24gaXMgaWdub3JlZC5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgaWRLZXk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogV2hlbiBlbmFibGVkLCBpdCBhcHBlbmQgdGhlIFRhZyBuYW1lIHRvIHRoZSByZWNvcmQuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IGluY2x1ZGVUYWdLZXk/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgICAqIEluZGV4IG5hbWUuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IGluZGV4Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFRpbWUgZm9ybWF0IChiYXNlZCBvbiBzdHJmdGltZSkgdG8gZ2VuZXJhdGUgdGhlIHNlY29uZCBwYXJ0IG9mIHRoZSBJbmRleFxuICAgICAqIG5hbWUuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICpcbiAgICAgKiBAc2VlIFtzdHJmdGltZV0oaHR0cDovL21hbjcub3JnL2xpbnV4L21hbi1wYWdlcy9tYW4zL3N0cmZ0aW1lLjMuaHRtbClcbiAgICAgKi9cbiAgcmVhZG9ubHkgbG9nc3Rhc2hEYXRlRm9ybWF0Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIEVuYWJsZSBMb2dzdGFzaCBmb3JtYXQgY29tcGF0aWJpbGl0eS5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgbG9nc3Rhc2hGb3JtYXQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gYGxvZ3N0YXNoRm9ybWF0YCBpcyBlbmFibGVkLCB0aGUgSW5kZXggbmFtZSBpcyBjb21wb3NlZCB1c2luZyBhXG4gICAgICogcHJlZml4IGFuZCB0aGUgZGF0ZSwgZS5nOiBJZiBgbG9nc3Rhc2hQcmVmaXhgIGlzIGVxdWFscyB0byAnbXlkYXRhJyB5b3VyXG4gICAgICogaW5kZXggd2lsbCBiZWNvbWUgJ215ZGF0YS1ZWVlZLk1NLkREJy5cbiAgICAgKlxuICAgICAqIFRoZSBsYXN0IHN0cmluZyBhcHBlbmRlZCBiZWxvbmdzIHRvIHRoZSBkYXRlIHdoZW4gdGhlIGRhdGEgaXMgYmVpbmdcbiAgICAgKiBnZW5lcmF0ZWQuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IGxvZ3N0YXNoUHJlZml4Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gaW5jbHVkZWQ6IHRoZSB2YWx1ZSBpbiB0aGUgcmVjb3JkIHRoYXQgYmVsb25ncyB0byB0aGUga2V5IHdpbGwgYmVcbiAgICAgKiBsb29rZWQgdXAgYW5kIG92ZXItd3JpdGUgdGhlIGBsb2dzdGFzaFByZWZpeGAgZm9yIGluZGV4IGdlbmVyYXRpb24uIElmXG4gICAgICogdGhlIGtleS92YWx1ZSBpcyBub3QgZm91bmQgaW4gdGhlIHJlY29yZCB0aGVuIHRoZSBgbG9nc3Rhc2hQcmVmaXhgIG9wdGlvblxuICAgICAqIHdpbGwgYWN0IGFzIGEgZmFsbGJhY2suXG4gICAgICpcbiAgICAgKiBOZXN0ZWQga2V5cyBhcmUgbm90IHN1cHBvcnRlZCAoaWYgZGVzaXJlZCwgeW91IGNhbiB1c2UgdGhlIG5lc3QgZmlsdGVyXG4gICAgICogcGx1Z2luIHRvIHJlbW92ZSBuZXN0aW5nKS5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgbG9nc3Rhc2hQcmVmaXhLZXk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogT3BlblNlYXJjaCBhY2NlcHRzIG5ldyBkYXRhIG9uIEhUVFAgcXVlcnkgcGF0aCBcIi9fYnVsa1wiLiBCdXQgaXQgaXMgYWxzb1xuICAgICAqIHBvc3NpYmxlIHRvIHNlcnZlIE9wZW5TZWFyY2ggYmVoaW5kIGEgcmV2ZXJzZSBwcm94eSBvbiBhIHN1YnBhdGguIFRoaXNcbiAgICAgKiBvcHRpb24gZGVmaW5lcyBzdWNoIHBhdGggb24gdGhlIGZsdWVudC1iaXQgc2lkZS4gSXQgc2ltcGx5IGFkZHMgYSBwYXRoXG4gICAgICogcHJlZml4IGluIHRoZSBpbmRleGluZyBIVFRQIFBPU1QgVVJJLlxuICAgICAqXG4gICAgICogQGdyb3VwIElucHV0c1xuICAgICAqL1xuICByZWFkb25seSBwYXRoPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIE9wZW5TZWFyY2ggYWxsb3dzIHRvIHNldHVwIGZpbHRlcnMgY2FsbGVkIHBpcGVsaW5lcy4gVGhpcyBvcHRpb24gYWxsb3dzXG4gICAgICogdG8gZGVmaW5lIHdoaWNoIHBpcGVsaW5lIHRoZSBkYXRhYmFzZSBzaG91bGQgdXNlLlxuICAgICAqXG4gICAgICogQGdyb3VwIElucHV0c1xuICAgICAqL1xuICByZWFkb25seSBwaXBlbGluZT86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBUQ1AgcG9ydCBvZiB0aGUgdGFyZ2V0IE9wZW5TZWFyY2ggaW5zdGFuY2UuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcblxuICAvKipcbiAgICAgKiBXaGVuIGVuYWJsZWQsIHJlcGxhY2UgZmllbGQgbmFtZSBkb3RzIHdpdGggdW5kZXJzY29yZS5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgcmVwbGFjZURvdHM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gZW5hYmxlZCwgbWFwcGluZyB0eXBlcyBpcyByZW1vdmVkIGFuZCBgdHlwZWAgb3B0aW9uIGlzIGlnbm9yZWQuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IHN1cHByZXNzVHlwZU5hbWU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gYGluY2x1ZGVUYWdLZXlgIGlzIGVuYWJsZWQsIHRoaXMgcHJvcGVydHkgZGVmaW5lcyB0aGUga2V5IG5hbWUgZm9yXG4gICAgICogdGhlIHRhZy5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgdGFnS2V5Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gYGxvZ3N0YXNoRm9ybWF0YCBpcyBlbmFibGVkLCBlYWNoIHJlY29yZCB3aWxsIGdldCBhIG5ldyB0aW1lc3RhbXBcbiAgICAgKiBmaWVsZC4gVGhlYHRpbWVLZXlgIHByb3BlcnR5IGRlZmluZXMgdGhlIG5hbWUgb2YgdGhhdCBmaWVsZC5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgdGltZUtleT86IHN0cmluZztcblxuICAvKipcbiAgICAgKiBXaGVuIGBsb2dzdGFzaEZvcm1hdGAgaXMgZW5hYmxlZCwgdGhpcyBwcm9wZXJ0eSBkZWZpbmVzIHRoZSBmb3JtYXQgb2YgdGhlXG4gICAgICogdGltZXN0YW1wLlxuICAgICAqXG4gICAgICogQGdyb3VwIElucHV0c1xuICAgICAqXG4gICAgICogQHNlZSBbc3RyZnRpbWVdKGh0dHA6Ly9tYW43Lm9yZy9saW51eC9tYW4tcGFnZXMvbWFuMy9zdHJmdGltZS4zLmh0bWwpXG4gICAgICovXG4gIHJlYWRvbmx5IHRpbWVLZXlGb3JtYXQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogV2hlbiBgbG9nc3Rhc2hGb3JtYXRgIGlzIGVuYWJsZWQsIGVuYWJsaW5nIHRoaXMgcHJvcGVydHkgc2VuZHMgbmFub3NlY29uZFxuICAgICAqIHByZWNpc2lvbiB0aW1lc3RhbXBzLlxuICAgICAqXG4gICAgICogQGdyb3VwIElucHV0c1xuICAgICAqL1xuICByZWFkb25seSB0aW1lS2V5TmFub3M/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgICAqIFdoZW4gZW5hYmxlZCBwcmludCB0aGUgT3BlblNlYXJjaCBBUEkgY2FsbHMgdG8gc3Rkb3V0IHdoZW4gT3BlblNlYXJjaFxuICAgICAqIHJldHVybnMgYW4gZXJyb3IgKGZvciBkaWFnIG9ubHkpLlxuICAgICAqXG4gICAgICogQGdyb3VwIElucHV0c1xuICAgICAqL1xuICByZWFkb25seSB0cmFjZUVycm9yPzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBXaGVuIGVuYWJsZWQgcHJpbnQgdGhlIE9wZW5TZWFyY2ggQVBJIGNhbGxzIHRvIHN0ZG91dCAoZm9yIGRpYWcgb25seSkuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IHRyYWNlT3V0cHV0PzogYm9vbGVhbjtcblxuICAvKipcbiAgICAgKiBUeXBlIG5hbWUuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IHR5cGU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgICogRW5hYmxlcyBkZWRpY2F0ZWQgdGhyZWFkKHMpIGZvciB0aGlzIG91dHB1dC5cbiAgICAgKlxuICAgICAqIEBncm91cCBJbnB1dHNcbiAgICAgKi9cbiAgcmVhZG9ubHkgd29ya2Vycz86IG51bWJlcjtcblxuICAvKipcbiAgICAgKiBPcGVyYXRpb24gdG8gdXNlIHRvIHdyaXRlIGluIGJ1bGsgcmVxdWVzdHMuXG4gICAgICpcbiAgICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAgICovXG4gIHJlYWRvbmx5IHdyaXRlT3BlcmF0aW9uPzogc3RyaW5nO1xuXG5cbiAgLyoqXG4gICAgKiBDcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBGbHVlbnRCaXRPcGVuU2VhcmNoT3V0cHV0IGNsYXNzLlxuICAgICpcbiAgICAqIEBwYXJhbSBvcHRpb25zIE9wdGlvbnMgZm9yIGNvbmZpZ3VyaW5nIHRoZSBvdXRwdXQuXG4gICAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKG9wdGlvbnM6IEZsdWVudEJpdE9wZW5TZWFyY2hPdXRwdXRPcHRpb25zKSB7XG4gICAgc3VwZXIoJ29wZW5zZWFyY2gnLCBvcHRpb25zKTtcblxuICAgIHRoaXMuYXdzQXV0aCA9IG9wdGlvbnMuYXdzQXV0aDtcbiAgICB0aGlzLmF3c0V4dGVybmFsSWQgPSBvcHRpb25zLmF3c0V4dGVybmFsSWQ7XG4gICAgdGhpcy5hd3NSZWdpb24gPSBvcHRpb25zLmF3c1JlZ2lvbjtcbiAgICB0aGlzLmF3c1JvbGUgPSBvcHRpb25zLmF3c1JvbGU7XG4gICAgdGhpcy5hd3NTdHNFbmRwb2ludCA9IG9wdGlvbnMuYXdzU3RzRW5kcG9pbnQ7XG4gICAgdGhpcy5idWZmZXJTaXplID0gb3B0aW9ucy5idWZmZXJTaXplO1xuICAgIHRoaXMuY3VycmVudFRpbWVJbmRleCA9IG9wdGlvbnMuY3VycmVudFRpbWVJbmRleDtcbiAgICB0aGlzLmRvbWFpbiA9IG9wdGlvbnMuZG9tYWluO1xuICAgIHRoaXMuZ2VuZXJhdGVJZCA9IG9wdGlvbnMuZ2VuZXJhdGVJZDtcbiAgICB0aGlzLmh0dHBQYXNzd2QgPSBvcHRpb25zLmh0dHBQYXNzd2Q7XG4gICAgdGhpcy5odHRwVXNlciA9IG9wdGlvbnMuaHR0cFVzZXI7XG4gICAgdGhpcy5pZEtleSA9IG9wdGlvbnMuaWRLZXk7XG4gICAgdGhpcy5pbmNsdWRlVGFnS2V5ID0gb3B0aW9ucy5pbmNsdWRlVGFnS2V5O1xuICAgIHRoaXMuaW5kZXggPSBvcHRpb25zLmluZGV4O1xuICAgIHRoaXMubG9nc3Rhc2hEYXRlRm9ybWF0ID0gb3B0aW9ucy5sb2dzdGFzaERhdGVGb3JtYXQ7XG4gICAgdGhpcy5sb2dzdGFzaEZvcm1hdCA9IG9wdGlvbnMubG9nc3Rhc2hGb3JtYXQ7XG4gICAgdGhpcy5sb2dzdGFzaFByZWZpeCA9IG9wdGlvbnMubG9nc3Rhc2hQcmVmaXg7XG4gICAgdGhpcy5sb2dzdGFzaFByZWZpeEtleSA9IG9wdGlvbnMubG9nc3Rhc2hQcmVmaXhLZXk7XG4gICAgdGhpcy5wYXRoID0gb3B0aW9ucy5wYXRoO1xuICAgIHRoaXMucGlwZWxpbmUgPSBvcHRpb25zLnBpcGVsaW5lO1xuICAgIHRoaXMucG9ydCA9IG9wdGlvbnMucG9ydCA/PyA5MjAwO1xuICAgIHRoaXMucmVwbGFjZURvdHMgPSBvcHRpb25zLnJlcGxhY2VEb3RzO1xuICAgIHRoaXMuc3VwcHJlc3NUeXBlTmFtZSA9IG9wdGlvbnMuc3VwcHJlc3NUeXBlTmFtZTtcbiAgICB0aGlzLnRhZ0tleSA9IG9wdGlvbnMudGFnS2V5O1xuICAgIHRoaXMudGltZUtleSA9IG9wdGlvbnMudGltZUtleTtcbiAgICB0aGlzLnRpbWVLZXlGb3JtYXQgPSBvcHRpb25zLnRpbWVLZXlGb3JtYXQ7XG4gICAgdGhpcy50aW1lS2V5TmFub3MgPSBvcHRpb25zLnRpbWVLZXlOYW5vcztcbiAgICB0aGlzLnRyYWNlRXJyb3IgPSBvcHRpb25zLnRyYWNlRXJyb3I7XG4gICAgdGhpcy50cmFjZU91dHB1dCA9IG9wdGlvbnMudHJhY2VPdXRwdXQ7XG4gICAgdGhpcy50eXBlID0gb3B0aW9ucy50eXBlO1xuICAgIHRoaXMud29ya2VycyA9IG9wdGlvbnMud29ya2VycztcbiAgICB0aGlzLndyaXRlT3BlcmF0aW9uID0gb3B0aW9ucy53cml0ZU9wZXJhdGlvbjtcbiAgfVxuXG4gIC8qKlxuICAgICAqIEJ1aWxkcyBhIGNvbmZpZ3VyYXRpb24gZm9yIHRoaXMgcGx1Z2luIGFuZCByZXR1cm5zIHRoZSBkZXRhaWxzIGZvclxuICAgICAqIGNvbnN1bXRpb24gYnkgYSByZXNvdXJjZSB0aGF0IGlzIGNvbmZpZ3VyaW5nIGxvZ2dpbmcuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgVGhlIGNvbnN0cnVjdCBjb25maWd1cmluZyBsb2dnaW5nIHVzaW5nIEZsdWVudCBCaXQuXG4gICAgICogQHJldHVybnMgQSBjb25maWd1cmF0aW9uIGZvciB0aGUgcGx1Z2luIHRoYXQgY29uIGJlIHVzZWQgYnkgdGhlIHJlc291cmNlXG4gICAgICogY29uZmlndXJpbmcgbG9nZ2luZy5cbiAgICAgKi9cbiAgcHVibGljIGJpbmQoc2NvcGU6IElDb25zdHJ1Y3QpOiBSZXNvbHZlZEZsdWVudEJpdENvbmZpZ3VyYXRpb24ge1xuICAgIHJldHVybiB7XG4gICAgICBjb25maWdGaWxlOiBzdXBlci5yZW5kZXJDb25maWdGaWxlKHtcbiAgICAgICAgQVdTX0F1dGg6IGNvbnZlcnRCb29sKHRoaXMuYXdzQXV0aCksXG4gICAgICAgIEFXU19FeHRlcm5hbF9JRDogdGhpcy5hd3NFeHRlcm5hbElkLFxuICAgICAgICBBV1NfUmVnaW9uOiB0aGlzLmF3c1JlZ2lvbiA/PyBTdGFjay5vZihzY29wZSkucmVnaW9uLFxuICAgICAgICBBV1NfUm9sZV9BUk46IHRoaXMuYXdzUm9sZT8ucm9sZUFybixcbiAgICAgICAgQVdTX1NUU19FbmRwb2ludDogdGhpcy5hd3NTdHNFbmRwb2ludCxcbiAgICAgICAgQnVmZmVyX1NpemU6IHRoaXMuYnVmZmVyU2l6ZT8udmFsdWUsXG4gICAgICAgIEN1cnJlbnRfVGltZV9JbmRleDogY29udmVydEJvb2wodGhpcy5jdXJyZW50VGltZUluZGV4KSxcbiAgICAgICAgR2VuZXJhdGVfSUQ6IGNvbnZlcnRCb29sKHRoaXMuZ2VuZXJhdGVJZCksXG4gICAgICAgIEhvc3Q6IHRoaXMuZG9tYWluLmRvbWFpbkVuZHBvaW50LFxuICAgICAgICBIVFRQX1Bhc3N3ZDogdGhpcy5odHRwUGFzc3dkLFxuICAgICAgICBIVFRQX1VzZXI6IHRoaXMuaHR0cFVzZXIsXG4gICAgICAgIElkX0tleTogdGhpcy5pZEtleSxcbiAgICAgICAgSW5jbHVkZV9UYWdfS2V5OiB0aGlzLmluY2x1ZGVUYWdLZXksXG4gICAgICAgIEluZGV4OiB0aGlzLmluZGV4LFxuICAgICAgICBMb2dzdGFzaF9EYXRlRm9ybWF0OiB0aGlzLmxvZ3N0YXNoRGF0ZUZvcm1hdCxcbiAgICAgICAgTG9nc3Rhc2hfRm9ybWF0OiBjb252ZXJ0Qm9vbCh0aGlzLmxvZ3N0YXNoRm9ybWF0KSxcbiAgICAgICAgTG9nc3Rhc2hfUHJlZml4OiB0aGlzLmxvZ3N0YXNoUHJlZml4LFxuICAgICAgICBMb2dzdGFzaF9QcmVmaXhfS2V5OiB0aGlzLmxvZ3N0YXNoUHJlZml4S2V5LFxuICAgICAgICBQYXRoOiB0aGlzLnBhdGgsXG4gICAgICAgIFBpcGVsaW5lOiB0aGlzLnBpcGVsaW5lLFxuICAgICAgICBQb3J0OiB0aGlzLnBvcnQsXG4gICAgICAgIFJlcGxhY2VfRG90czogY29udmVydEJvb2wodGhpcy5yZXBsYWNlRG90cyksXG4gICAgICAgIFN1cHByZXNzX1R5cGVfTmFtZTogY29udmVydEJvb2wodGhpcy5zdXBwcmVzc1R5cGVOYW1lKSxcbiAgICAgICAgVGFnX0tleTogdGhpcy50YWdLZXksXG4gICAgICAgIFRpbWVfS2V5OiB0aGlzLnRpbWVLZXksXG4gICAgICAgIFRpbWVfS2V5X0Zvcm1hdDogdGhpcy50aW1lS2V5Rm9ybWF0LFxuICAgICAgICBUaW1lX0tleV9OYW5vczogY29udmVydEJvb2wodGhpcy50aW1lS2V5TmFub3MpLFxuICAgICAgICBUcmFjZV9FcnJvcjogY29udmVydEJvb2wodGhpcy50cmFjZUVycm9yKSxcbiAgICAgICAgVHJhY2VfT3V0cHV0OiBjb252ZXJ0Qm9vbCh0aGlzLnRyYWNlT3V0cHV0KSxcbiAgICAgICAgVHlwZTogdGhpcy50eXBlLFxuICAgICAgICBXb3JrZXJzOiB0aGlzLndvcmtlcnMsXG4gICAgICAgIFdyaXRlX09wZXJhdGlvbjogdGhpcy53cml0ZU9wZXJhdGlvbixcbiAgICAgIH0pLFxuICAgIH07XG4gIH1cbn0iXX0=