"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitOutputPluginBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const fluent_bit_plugin_1 = require("../fluent-bit-plugin");
/**
 * Represents a Fluent Bit plugin that controls log output to a given
 * destination.
 */
class FluentBitOutputPluginBase extends fluent_bit_plugin_1.FluentBitPlugin {
    /**
     * Creates a new instance of the FluentBitOutputPlugin class.
     *
     * @param name The name of the output plugin to configure.
     * @param options Configuration options that apply to all Fluent Bit output
     * plugin.
     */
    constructor(name, options = {}) {
        super({
            name: name,
            pluginType: fluent_bit_plugin_1.FluentBitPluginType.OUTPUT,
        });
        this.match = options.match ?? __1.FluentBitMatch.ALL;
    }
    /**
     * Renders a Fluent Bit configuration file for the plugin.
     *
     * @param config The configuration options to render into a configuration
     * file.
     * @returns A rendered plugin configuration file.
     */
    renderConfigFile(config) {
        return super.renderConfigFile({
            ...this.match.toObject(),
            ...config,
        });
    }
}
exports.FluentBitOutputPluginBase = FluentBitOutputPluginBase;
_a = JSII_RTTI_SYMBOL_1;
FluentBitOutputPluginBase[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitOutputPluginBase", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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