import { IStream } from 'aws-cdk-lib/aws-kinesis';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import { IDomain } from 'aws-cdk-lib/aws-opensearchservice';
import { IFluentBitOutputPlugin } from '.';
import { FluentBitMatch } from '..';
import { IDeliveryStream } from '../../../../kinesis-firehose';
/**
 * Common options that allow configuration of destinations where Fluent Bit
 * should send records after processing.
 */
export declare class FluentBitOutput {
    /**
       * Sends matched records to a CloudWatch Logs log group.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param logGroup The log group where matched records should be sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static cloudwatchLogs(match: FluentBitMatch, logGroup: ILogGroup): IFluentBitOutputPlugin;
    /**
       * Sends matched records to a Kinesis data stream.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param stream The Kinesis stream where matched records should be sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static kinesis(match: FluentBitMatch, stream: IStream): IFluentBitOutputPlugin;
    /**
       * Sends matched records to a Kinesis Firehose delivery stream.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param deliveryStream The Firehose delivery stream where matched
       * records should be sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static kinesisFirehose(match: FluentBitMatch, deliveryStream: IDeliveryStream): IFluentBitOutputPlugin;
    /**
       * Sends matched records to an OpenSearch domain.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param domain The OpenSearch domain where matched records should be
       * sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static opensearch(match: FluentBitMatch, domain: IDomain): IFluentBitOutputPlugin;
}
