"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitOutput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
/**
 * Common options that allow configuration of destinations where Fluent Bit
 * should send records after processing.
 */
class FluentBitOutput {
    /**
       * Sends matched records to a CloudWatch Logs log group.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param logGroup The log group where matched records should be sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static cloudwatchLogs(match, logGroup) {
        return new _1.FluentBitCloudWatchLogsOutput({
            logGroup: _1.FluentBitLogGroupOutput.fromLogGroup(logGroup),
            match: match,
        });
    }
    /**
       * Sends matched records to a Kinesis data stream.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param stream The Kinesis stream where matched records should be sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static kinesis(match, stream) {
        return new _1.FluentBitKinesisOutput({
            match: match,
            stream: stream,
        });
    }
    /**
       * Sends matched records to a Kinesis Firehose delivery stream.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param deliveryStream The Firehose delivery stream where matched
       * records should be sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static kinesisFirehose(match, deliveryStream) {
        return new _1.FluentBitKinesisFirehoseOutput({
            deliveryStream: deliveryStream,
            match: match,
        });
    }
    /**
       * Sends matched records to an OpenSearch domain.
       *
       * @param match A pattern filtering to which records the output should be
       * applied.
       * @param domain The OpenSearch domain where matched records should be
       * sent.
       * @returns An output filter object that can be applied to the Fluent Bit
       * configuration.
       */
    static opensearch(match, domain) {
        return new _1.FluentBitOpenSearchOutput({
            domain: domain,
            match: match,
        });
    }
}
exports.FluentBitOutput = FluentBitOutput;
_a = JSII_RTTI_SYMBOL_1;
FluentBitOutput[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitOutput", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3V0cHV0LXBsdWdpbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9rOHMtYXdzL2xpYi9mbHVlbnQtYml0L291dHB1dHMvb3V0cHV0LXBsdWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLHdCQUFzTDtBQUt0TDs7O0dBR0c7QUFDSCxNQUFhLGVBQWU7SUFDMUI7Ozs7Ozs7O1NBUUs7SUFDRSxNQUFNLENBQUMsY0FBYyxDQUFDLEtBQXFCLEVBQUUsUUFBbUI7UUFDckUsT0FBTyxJQUFJLGdDQUE2QixDQUFDO1lBQ3ZDLFFBQVEsRUFBRSwwQkFBdUIsQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDO1lBQ3hELEtBQUssRUFBRSxLQUFLO1NBQ2IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVEOzs7Ozs7OztTQVFLO0lBQ0UsTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFxQixFQUFFLE1BQWU7UUFDMUQsT0FBTyxJQUFJLHlCQUFzQixDQUFDO1lBQ2hDLEtBQUssRUFBRSxLQUFLO1lBQ1osTUFBTSxFQUFFLE1BQU07U0FDZixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQ7Ozs7Ozs7OztTQVNLO0lBQ0UsTUFBTSxDQUFDLGVBQWUsQ0FBQyxLQUFxQixFQUFFLGNBQStCO1FBQ2xGLE9BQU8sSUFBSSxpQ0FBOEIsQ0FBQztZQUN4QyxjQUFjLEVBQUUsY0FBYztZQUM5QixLQUFLLEVBQUUsS0FBSztTQUNiLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRDs7Ozs7Ozs7O1NBU0s7SUFDRSxNQUFNLENBQUMsVUFBVSxDQUFDLEtBQXFCLEVBQUUsTUFBZTtRQUM3RCxPQUFPLElBQUksNEJBQXlCLENBQUM7WUFDbkMsTUFBTSxFQUFFLE1BQU07WUFDZCxLQUFLLEVBQUUsS0FBSztTQUNiLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBakVILDBDQWtFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElTdHJlYW0gfSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mta2luZXNpcyc7XG5pbXBvcnQgeyBJTG9nR3JvdXAgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbG9ncyc7XG5pbXBvcnQgeyBJRG9tYWluIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLW9wZW5zZWFyY2hzZXJ2aWNlJztcbmltcG9ydCB7IEZsdWVudEJpdENsb3VkV2F0Y2hMb2dzT3V0cHV0LCBGbHVlbnRCaXRLaW5lc2lzRmlyZWhvc2VPdXRwdXQsIEZsdWVudEJpdEtpbmVzaXNPdXRwdXQsIEZsdWVudEJpdExvZ0dyb3VwT3V0cHV0LCBGbHVlbnRCaXRPcGVuU2VhcmNoT3V0cHV0LCBJRmx1ZW50Qml0T3V0cHV0UGx1Z2luIH0gZnJvbSAnLic7XG5pbXBvcnQgeyBGbHVlbnRCaXRNYXRjaCB9IGZyb20gJy4uJztcbmltcG9ydCB7IElEZWxpdmVyeVN0cmVhbSB9IGZyb20gJy4uLy4uLy4uLy4uL2tpbmVzaXMtZmlyZWhvc2UnO1xuXG5cbi8qKlxuICogQ29tbW9uIG9wdGlvbnMgdGhhdCBhbGxvdyBjb25maWd1cmF0aW9uIG9mIGRlc3RpbmF0aW9ucyB3aGVyZSBGbHVlbnQgQml0XG4gKiBzaG91bGQgc2VuZCByZWNvcmRzIGFmdGVyIHByb2Nlc3NpbmcuXG4gKi9cbmV4cG9ydCBjbGFzcyBGbHVlbnRCaXRPdXRwdXQge1xuICAvKipcbiAgICAgKiBTZW5kcyBtYXRjaGVkIHJlY29yZHMgdG8gYSBDbG91ZFdhdGNoIExvZ3MgbG9nIGdyb3VwLlxuICAgICAqXG4gICAgICogQHBhcmFtIG1hdGNoIEEgcGF0dGVybiBmaWx0ZXJpbmcgdG8gd2hpY2ggcmVjb3JkcyB0aGUgb3V0cHV0IHNob3VsZCBiZVxuICAgICAqIGFwcGxpZWQuXG4gICAgICogQHBhcmFtIGxvZ0dyb3VwIFRoZSBsb2cgZ3JvdXAgd2hlcmUgbWF0Y2hlZCByZWNvcmRzIHNob3VsZCBiZSBzZW50LlxuICAgICAqIEByZXR1cm5zIEFuIG91dHB1dCBmaWx0ZXIgb2JqZWN0IHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gdGhlIEZsdWVudCBCaXRcbiAgICAgKiBjb25maWd1cmF0aW9uLlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGNsb3Vkd2F0Y2hMb2dzKG1hdGNoOiBGbHVlbnRCaXRNYXRjaCwgbG9nR3JvdXA6IElMb2dHcm91cCk6IElGbHVlbnRCaXRPdXRwdXRQbHVnaW4ge1xuICAgIHJldHVybiBuZXcgRmx1ZW50Qml0Q2xvdWRXYXRjaExvZ3NPdXRwdXQoe1xuICAgICAgbG9nR3JvdXA6IEZsdWVudEJpdExvZ0dyb3VwT3V0cHV0LmZyb21Mb2dHcm91cChsb2dHcm91cCksXG4gICAgICBtYXRjaDogbWF0Y2gsXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICAgKiBTZW5kcyBtYXRjaGVkIHJlY29yZHMgdG8gYSBLaW5lc2lzIGRhdGEgc3RyZWFtLlxuICAgICAqXG4gICAgICogQHBhcmFtIG1hdGNoIEEgcGF0dGVybiBmaWx0ZXJpbmcgdG8gd2hpY2ggcmVjb3JkcyB0aGUgb3V0cHV0IHNob3VsZCBiZVxuICAgICAqIGFwcGxpZWQuXG4gICAgICogQHBhcmFtIHN0cmVhbSBUaGUgS2luZXNpcyBzdHJlYW0gd2hlcmUgbWF0Y2hlZCByZWNvcmRzIHNob3VsZCBiZSBzZW50LlxuICAgICAqIEByZXR1cm5zIEFuIG91dHB1dCBmaWx0ZXIgb2JqZWN0IHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gdGhlIEZsdWVudCBCaXRcbiAgICAgKiBjb25maWd1cmF0aW9uLlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGtpbmVzaXMobWF0Y2g6IEZsdWVudEJpdE1hdGNoLCBzdHJlYW06IElTdHJlYW0pOiBJRmx1ZW50Qml0T3V0cHV0UGx1Z2luIHtcbiAgICByZXR1cm4gbmV3IEZsdWVudEJpdEtpbmVzaXNPdXRwdXQoe1xuICAgICAgbWF0Y2g6IG1hdGNoLFxuICAgICAgc3RyZWFtOiBzdHJlYW0sXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICAgKiBTZW5kcyBtYXRjaGVkIHJlY29yZHMgdG8gYSBLaW5lc2lzIEZpcmVob3NlIGRlbGl2ZXJ5IHN0cmVhbS5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBtYXRjaCBBIHBhdHRlcm4gZmlsdGVyaW5nIHRvIHdoaWNoIHJlY29yZHMgdGhlIG91dHB1dCBzaG91bGQgYmVcbiAgICAgKiBhcHBsaWVkLlxuICAgICAqIEBwYXJhbSBkZWxpdmVyeVN0cmVhbSBUaGUgRmlyZWhvc2UgZGVsaXZlcnkgc3RyZWFtIHdoZXJlIG1hdGNoZWRcbiAgICAgKiByZWNvcmRzIHNob3VsZCBiZSBzZW50LlxuICAgICAqIEByZXR1cm5zIEFuIG91dHB1dCBmaWx0ZXIgb2JqZWN0IHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gdGhlIEZsdWVudCBCaXRcbiAgICAgKiBjb25maWd1cmF0aW9uLlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGtpbmVzaXNGaXJlaG9zZShtYXRjaDogRmx1ZW50Qml0TWF0Y2gsIGRlbGl2ZXJ5U3RyZWFtOiBJRGVsaXZlcnlTdHJlYW0pOiBJRmx1ZW50Qml0T3V0cHV0UGx1Z2luIHtcbiAgICByZXR1cm4gbmV3IEZsdWVudEJpdEtpbmVzaXNGaXJlaG9zZU91dHB1dCh7XG4gICAgICBkZWxpdmVyeVN0cmVhbTogZGVsaXZlcnlTdHJlYW0sXG4gICAgICBtYXRjaDogbWF0Y2gsXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICAgKiBTZW5kcyBtYXRjaGVkIHJlY29yZHMgdG8gYW4gT3BlblNlYXJjaCBkb21haW4uXG4gICAgICpcbiAgICAgKiBAcGFyYW0gbWF0Y2ggQSBwYXR0ZXJuIGZpbHRlcmluZyB0byB3aGljaCByZWNvcmRzIHRoZSBvdXRwdXQgc2hvdWxkIGJlXG4gICAgICogYXBwbGllZC5cbiAgICAgKiBAcGFyYW0gZG9tYWluIFRoZSBPcGVuU2VhcmNoIGRvbWFpbiB3aGVyZSBtYXRjaGVkIHJlY29yZHMgc2hvdWxkIGJlXG4gICAgICogc2VudC5cbiAgICAgKiBAcmV0dXJucyBBbiBvdXRwdXQgZmlsdGVyIG9iamVjdCB0aGF0IGNhbiBiZSBhcHBsaWVkIHRvIHRoZSBGbHVlbnQgQml0XG4gICAgICogY29uZmlndXJhdGlvbi5cbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyBvcGVuc2VhcmNoKG1hdGNoOiBGbHVlbnRCaXRNYXRjaCwgZG9tYWluOiBJRG9tYWluKTogSUZsdWVudEJpdE91dHB1dFBsdWdpbiB7XG4gICAgcmV0dXJuIG5ldyBGbHVlbnRCaXRPcGVuU2VhcmNoT3V0cHV0KHtcbiAgICAgIGRvbWFpbjogZG9tYWluLFxuICAgICAgbWF0Y2g6IG1hdGNoLFxuICAgIH0pO1xuICB9XG59Il19