"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitJsonParser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const parser_plugin_base_1 = require("./parser-plugin-base");
/**
 * A Fluent Bit filter that parsed inbound messages in JSON format.
 */
class FluentBitJsonParser extends parser_plugin_base_1.FluentBitParserPluginBase {
    /**
     * Creates a new instance of the FluentBitJsonParser class.
     *
     * @param options Options for configuring the parser.
     */
    constructor(name, options = {}) {
        super(name, 'json', options);
        this.timeFormat = options.timeFormat;
        this.timeKey = options.timeKey;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        return {
            configFile: super.renderConfigFile({
                Time_Format: this.timeFormat,
                Time_Key: this.timeKey,
            }),
        };
    }
}
exports.FluentBitJsonParser = FluentBitJsonParser;
_a = JSII_RTTI_SYMBOL_1;
FluentBitJsonParser[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitJsonParser", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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