"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitLogfmtParser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const parser_plugin_base_1 = require("./parser-plugin-base");
/**
 * A Fluent Bit filter that parsed inbound messages in LTSV format.
 */
class FluentBitLogfmtParser extends parser_plugin_base_1.FluentBitParserPluginBase {
    /**
     * Creates a new instance of the FluentBitLogfmtParser class.
     *
     * @param options Options for configuring the parser.
     */
    constructor(name, options = {}) {
        super(name, 'logfmt', options);
        this.timeFormat = options.timeFormat;
        this.timeKey = options.timeKey;
        this.types = options.types;
    }
    /**
     * Builds a configuration for this plugin and returns the details for
     * consumtion by a resource that is configuring logging.
     *
     * @param _scope The construct configuring logging using Fluent Bit.
     * @returns A configuration for the plugin that con be used by the resource
     * configuring logging.
     */
    bind(_scope) {
        const types = this.types ?? {};
        const noTypes = !Object.keys(types).length;
        return {
            configFile: super.renderConfigFile({
                Time_Format: this.timeFormat,
                Time_Key: this.timeKey,
                Types: noTypes ? undefined : Object.keys(types).map((x) => {
                    return `${x}:${types[x].name}`;
                }).join(' '),
            }),
        };
    }
}
exports.FluentBitLogfmtParser = FluentBitLogfmtParser;
_a = JSII_RTTI_SYMBOL_1;
FluentBitLogfmtParser[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitLogfmtParser", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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