"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitLtsvParser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const parser_plugin_base_1 = require("./parser-plugin-base");
/**
 * A Fluent Bit filter that parsed inbound messages in LTSV format.
 */
class FluentBitLtsvParser extends parser_plugin_base_1.FluentBitParserPluginBase {
    /**
     * Creates a new instance of the FluentBitLtsvParser class.
     *
     * @param options Options for configuring the parser.
     */
    constructor(name, options = {}) {
        super(name, 'ltsv', options);
        this.timeFormat = options.timeFormat;
        this.timeKey = options.timeKey;
        this.types = options.types;
    }
    /**
     * Builds a configuration for this plugin and returns the details for
     * consumtion by a resource that is configuring logging.
     *
     * @param _scope The construct configuring logging using Fluent Bit.
     * @returns A configuration for the plugin that con be used by the resource
     * configuring logging.
     */
    bind(_scope) {
        const types = this.types ?? {};
        const noTypes = !Object.keys(types).length;
        return {
            configFile: super.renderConfigFile({
                Time_Format: this.timeFormat,
                Time_Key: this.timeKey,
                Types: noTypes ? undefined : Object.keys(types).map((x) => {
                    return `${x}:${types[x].name}`;
                }).join(' '),
            }),
        };
    }
}
exports.FluentBitLtsvParser = FluentBitLtsvParser;
_a = JSII_RTTI_SYMBOL_1;
FluentBitLtsvParser[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitLtsvParser", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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