import { FluentBitPlugin, IFluentBitPlugin } from '../fluent-bit-plugin';
/**
 * Represents the various types of data that can be mapped in Fluent Bit using
 * a parser plugin.
 */
export declare class ParserPluginDataType {
    /**
       * Object that is true or false.
       */
    static readonly BOOL: ParserPluginDataType;
    /**
       * Floating point number values.
       */
    static readonly FLOAT: ParserPluginDataType;
    /**
       * Hexidecimal number values.
       */
    static readonly HEX: ParserPluginDataType;
    /**
       * While number values.
       */
    static readonly INTEGER: ParserPluginDataType;
    /**
       * Logfmt formatted data.
       *
       * @see [Logfmt overview](https://brandur.org/logfmt)
       * @see [Golang logfmt documentation](https://pkg.go.dev/github.com/kr/logfmt)
       */
    static readonly LOGFMT: ParserPluginDataType;
    /**
       * Labeled tab-separated values.
       *
       * @see [LTSV](http://ltsv.org/)
       */
    static readonly LTSV: ParserPluginDataType;
    /**
       * Regular expression.
       */
    static readonly REGEX: ParserPluginDataType;
    /**
       * Text data.
       */
    static readonly STRING: ParserPluginDataType;
    /**
       * An escape hatch method that allow specifying arbitrary custom data
       * types.
       *
       * @param name The name of the data type.
       * @returns An object representing the data type.
       */
    static of(name: string): ParserPluginDataType;
    /**
       * The name of the data type.
       */
    readonly name: string;
    /**
       * Cretaes a new instance of the ParserPluginDataType class.
       *
       * @param name The name of the data type.
       */
    private constructor();
}
/**
 * Configuration options that apply to all Fluent Bit parser plugins.
 */
export interface FluentBitParserPluginCommonOptions {
}
/**
 * Represents a Fluent Bit plugin that parses inbound records to populate
 * fields.
 */
export interface IFluentBitParserPlugin extends IFluentBitPlugin {
    readonly format: string;
}
/**
 * Represents a Fluent Bit plugin that parses inbound records to populate
 * fields.
 */
export declare abstract class FluentBitParserPluginBase extends FluentBitPlugin implements IFluentBitParserPlugin {
    /**
     * The data format that the parser extracts records from.
     *
     * @group Inputs
     */
    readonly format: string;
    /**
     * Creates a new instance of the FluentBitParserPlugin class.
     *
     * @param name The name of the output plugin to configure.
     * @param format The data format that the parser extracts records from.
     * @param options Configuration options that apply to all Fluent Bit output
     * plugin.
     */
    constructor(name: string, format: string, _options?: FluentBitParserPluginCommonOptions);
    /**
     * Renders a Fluent Bit configuration file for the plugin.
     *
     * @param config The configuration options to render into a configuration
     * file.
     * @returns A rendered plugin configuration file.
     */
    protected renderConfigFile(config: {
        [key: string]: any;
    }): string;
}
