"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitParserPluginBase = exports.ParserPluginDataType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fluent_bit_plugin_1 = require("../fluent-bit-plugin");
/**
 * Represents the various types of data that can be mapped in Fluent Bit using
 * a parser plugin.
 */
class ParserPluginDataType {
    /**
       * Cretaes a new instance of the ParserPluginDataType class.
       *
       * @param name The name of the data type.
       */
    constructor(name) {
        this.name = name;
    }
    /**
       * An escape hatch method that allow specifying arbitrary custom data
       * types.
       *
       * @param name The name of the data type.
       * @returns An object representing the data type.
       */
    static of(name) {
        return new ParserPluginDataType(name);
    }
}
exports.ParserPluginDataType = ParserPluginDataType;
_a = JSII_RTTI_SYMBOL_1;
ParserPluginDataType[_a] = { fqn: "cdk-extensions.k8s_aws.ParserPluginDataType", version: "0.0.38" };
/**
   * Object that is true or false.
   */
ParserPluginDataType.BOOL = ParserPluginDataType.of('bool');
/**
   * Floating point number values.
   */
ParserPluginDataType.FLOAT = ParserPluginDataType.of('float');
/**
   * Hexidecimal number values.
   */
ParserPluginDataType.HEX = ParserPluginDataType.of('hex');
/**
   * While number values.
   */
ParserPluginDataType.INTEGER = ParserPluginDataType.of('integer');
/**
   * Logfmt formatted data.
   *
   * @see [Logfmt overview](https://brandur.org/logfmt)
   * @see [Golang logfmt documentation](https://pkg.go.dev/github.com/kr/logfmt)
   */
ParserPluginDataType.LOGFMT = ParserPluginDataType.of('logfmt');
/**
   * Labeled tab-separated values.
   *
   * @see [LTSV](http://ltsv.org/)
   */
ParserPluginDataType.LTSV = ParserPluginDataType.of('ltsv');
/**
   * Regular expression.
   */
ParserPluginDataType.REGEX = ParserPluginDataType.of('regex');
/**
   * Text data.
   */
ParserPluginDataType.STRING = ParserPluginDataType.of('string');
/**
 * Represents a Fluent Bit plugin that parses inbound records to populate
 * fields.
 */
class FluentBitParserPluginBase extends fluent_bit_plugin_1.FluentBitPlugin {
    /**
     * Creates a new instance of the FluentBitParserPlugin class.
     *
     * @param name The name of the output plugin to configure.
     * @param format The data format that the parser extracts records from.
     * @param options Configuration options that apply to all Fluent Bit output
     * plugin.
     */
    constructor(name, format, _options = {}) {
        super({
            name: name,
            pluginType: fluent_bit_plugin_1.FluentBitPluginType.PARSER,
        });
        this.format = format;
    }
    /**
     * Renders a Fluent Bit configuration file for the plugin.
     *
     * @param config The configuration options to render into a configuration
     * file.
     * @returns A rendered plugin configuration file.
     */
    renderConfigFile(config) {
        return super.renderConfigFile({
            Format: this.format,
            ...config,
        });
    }
}
exports.FluentBitParserPluginBase = FluentBitParserPluginBase;
_b = JSII_RTTI_SYMBOL_1;
FluentBitParserPluginBase[_b] = { fqn: "cdk-extensions.k8s_aws.FluentBitParserPluginBase", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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