"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitParser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
/**
 * Standard parse comfigurations which can be applied to Fluent Bit to allow
 * for parsing data from incoming records.
 *
 * The records to which parsers are applied is controlled using the parser
 * filter.
 *
 * @see {@link FluentBitParserFilter}
 */
class FluentBitParser {
    /**
       * Creates a parser that processes records that are formatted in JSON.
       *
       * @param name The name of the parser which will be used for referencing it
       * in other configurations.
       * @returns A parser object that can be applied to the Fluent Bit
       * configuration.
       */
    static json(name) {
        return new _1.FluentBitJsonParser(name);
    }
    /**
       * Creates a parser that processes records that are formatted using the
       * `logfmt` standard.
       *
       * @see [Logfmt overview](https://brandur.org/logfmt)
       * @see [Golang logfmt documentation](https://pkg.go.dev/github.com/kr/logfmt)
       *
       * @param name The name of the parser which will be used for referencing it
       * in other configurations.
       * @returns A parser object that can be applied to the Fluent Bit
       * configuration.
       */
    static logfmt(name) {
        return new _1.FluentBitLogfmtParser(name);
    }
    /**
       * Creates a parser that processes records that are formatted using the
       * `ltsv` standard.
       *
       * @see [LTSV](http://ltsv.org/)
       *
       * @param name The name of the parser which will be used for referencing it
       * in other configurations.
       * @returns A parser object that can be applied to the Fluent Bit
       * configuration.
       */
    static ltsv(name) {
        return new _1.FluentBitLtsvParser(name);
    }
    /**
       * Creates a parser that uses regular expressions to parse incoming
       * records.
       *
       * @param name The name of the parser which will be used for referencing it
       * in other configurations.
       * @param regex The regular expression to use to parse records.
       * @returns A parser object that can be applied to the Fluent Bit
       * configuration.
       */
    static regex(name, regex) {
        return new _1.FluentBitRegexParser(name, {
            regex: regex,
        });
    }
}
exports.FluentBitParser = FluentBitParser;
_a = JSII_RTTI_SYMBOL_1;
FluentBitParser[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitParser", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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