"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitRegexParser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const parser_plugin_base_1 = require("./parser-plugin-base");
/**
 * A Fluent Bit filter that parsed inbound messages using regular expressions.
 */
class FluentBitRegexParser extends parser_plugin_base_1.FluentBitParserPluginBase {
    /**
     * Creates a new instance of the FluentBitLtsvParser class.
     *
     * @param options Options for configuring the parser.
     */
    constructor(name, options) {
        super(name, 'regex', options);
        this.regex = options.regex;
        this.skipEmptyValues = options.skipEmptyValues;
        this.timeFormat = options.timeFormat;
        this.timeKey = options.timeKey;
        this.types = options.types;
    }
    /**
     * Builds a configuration for this plugin and returns the details for
     * consumtion by a resource that is configuring logging.
     *
     * @param _scope The construct configuring logging using Fluent Bit.
     * @returns A configuration for the plugin that con be used by the resource
     * configuring logging.
     */
    bind(_scope) {
        const types = this.types ?? {};
        const noTypes = !Object.keys(types).length;
        return {
            configFile: super.renderConfigFile({
                Regex: this.regex,
                Skip_Empty_Values: this.skipEmptyValues,
                Time_Format: this.timeFormat,
                Time_Key: this.timeKey,
                Types: noTypes ? undefined : Object.keys(types).map((x) => {
                    return `${x}:${types[x].name}`;
                }).join(' '),
            }),
        };
    }
}
exports.FluentBitRegexParser = FluentBitRegexParser;
_a = JSII_RTTI_SYMBOL_1;
FluentBitRegexParser[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitRegexParser", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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