"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManagerReference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines a reference for importing and synchronizing a Secrets Manager secret
 * to a Kubernetes secret.
 */
class SecretsManagerReference {
    /**
       * Creates a new instance of the SecretsManagerReference class.
       *
       * @param secret The secret being referenced to import into Kubernetes.
       * @param options Configuration options for the Secrets Manager reference.
       */
    constructor(secret, options = {}) {
        this._fields = [];
        this.secret = secret;
        options.fields?.forEach((x) => {
            this.addFieldMapping(x);
        });
    }
    /**
       * An array of field mappings which will be applied to this secret
       * reference when mapping keys from SecretsManager JSON objects to keys in
       * the imported secret.
       */
    get fields() {
        return [...this._fields];
    }
    /**
       * Adds a field mapping that specifies how a field from a Secrets Manager
       * JSON secret should be mapped into the imported Kubernetes secret.
       *
       * @param field The configuration for how to map the field from Secrets
       * Manager to the Kubernetes secret.
       * @returns The `SecretsManagerReference` where the mapping was added.
       */
    addFieldMapping(field) {
        this._fields.push(field);
        return this;
    }
    /**
       * Binds the reference to an object that is in charge of generating the
       * manifest for the external secret.
       *
       * @param _scope The construct that will consume the generated
       * configuration.
       * @returns A configuration object providing the details needed to build
       * the external secret Kubernetes resource.
       */
    bind(_scope) {
        return {
            fields: !this._fields.length ? undefined : this._fields.map((x) => {
                return {
                    kubernetesKey: x.kubernetesKey,
                    remoteKey: x.remoteKey ?? x.kubernetesKey,
                };
            }),
            remoteRef: this.secret.secretArn,
        };
    }
}
exports.SecretsManagerReference = SecretsManagerReference;
_a = JSII_RTTI_SYMBOL_1;
SecretsManagerReference[_a] = { fqn: "cdk-extensions.k8s_aws.SecretsManagerReference", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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