"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmParameterReference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines a reference for importing and synchronizing an SSM parameter to a
 * Kubernetes secret.
 */
class SsmParameterReference {
    /**
       * Creates a new instance of the SsmParameterReference class.
       *
       * @param parameter The SSM parameter being referenced to import into
       * Kubernetes.
       */
    constructor(parameter, options) {
        this._fields = [];
        this.parameter = parameter;
        options.fields?.forEach((x) => {
            this.addFieldMapping(x);
        });
    }
    /**
       * An array of field mappings which will be applied to this secret
       * reference when mapping keys from SSM parameter JSON objects to keys in
       * the imported secret.
       */
    get fields() {
        return [...this._fields];
    }
    /**
       * Adds a field mapping that specifies how a field from an SSM JSON
       * parameter should be mapped into the imported Kubernetes secret.
       *
       * @param field The configuration for how to map the field from the SSM
       * parameter to the Kubernetes secret.
       * @returns The `SsmParameterReference` where the mapping was added.
       */
    addFieldMapping(field) {
        this._fields.push(field);
        return this;
    }
    /**
       * Binds the reference to an object that is in charge of generating the
       * manifest for the external secret.
       *
       * @param _scope The construct that will consume the generated
       * configuration.
       * @returns A configuration object providing the details needed to build
       * the external secret Kubernetes resource.
       */
    bind(_scope) {
        return {
            fields: !this._fields.length ? undefined : this._fields.map((x) => {
                return {
                    kubernetesKey: x.kubernetesKey,
                    remoteKey: x.remoteKey ?? x.kubernetesKey,
                };
            }),
            remoteRef: this.parameter.parameterArn,
        };
    }
}
exports.SsmParameterReference = SsmParameterReference;
_a = JSII_RTTI_SYMBOL_1;
SsmParameterReference[_a] = { fqn: "cdk-extensions.k8s_aws.SsmParameterReference", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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