"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLoggingConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const formatting_1 = require("../../utils/formatting");
class CloudWatchLoggingConfiguration {
    constructor(options) {
        this.enabled = options.enabled;
        this._logGroup = options.logGroup;
        this._logStream = options.logStream;
        if (this.enabled === undefined && (this.logGroup || this.logStream)) {
            this.enabled = true;
        }
    }
    // Internal accessors
    get logGroup() {
        return this._logGroup;
    }
    get logStream() {
        return this._logStream;
    }
    bind(scope) {
        if (this.enabled && !this.logGroup) {
            const logGroup = scope.node.tryFindChild('delivery-stream-log-group');
            this._logGroup = logGroup ?? new aws_logs_1.LogGroup(scope, 'delivery-stream-log-group', {
                removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                retention: aws_logs_1.RetentionDays.TWO_WEEKS,
            });
        }
        if (this.enabled && !this.logStream) {
            const logStream = scope.node.tryFindChild('delivery-stream-log-stream');
            if (logStream) {
                this._logStream = logStream;
            }
            else if (this.logGroup) {
                this._logStream = this._logStream = new aws_logs_1.LogStream(scope, 'delivery-stream-log-stream', {
                    logGroup: this.logGroup,
                    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                });
            }
            else {
                aws_cdk_lib_1.Annotations.of(scope).addError([
                    'When specifying Firehose Delivery Stream logging',
                    'configuration you cannot specify a log stream without',
                    'also specifying a log group.',
                ].join(' '));
            }
        }
        return formatting_1.definedFieldsOrUndefined({
            enabled: this.enabled,
            logGroupName: this.logGroup?.logGroupName,
            logStreamName: this.logStream?.logStreamName,
        });
    }
}
exports.CloudWatchLoggingConfiguration = CloudWatchLoggingConfiguration;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLoggingConfiguration[_a] = { fqn: "cdk-extensions.kinesis_firehose.CloudWatchLoggingConfiguration", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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