"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenxJsonInputSerDe = exports.HiveJsonInputSerDe = exports.InputFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class InputFormat {
    static hiveJson(options) {
        return new HiveJsonInputSerDe(options);
    }
    static openxJson(options) {
        return new OpenxJsonInputSerDe(options);
    }
}
exports.InputFormat = InputFormat;
_a = JSII_RTTI_SYMBOL_1;
InputFormat[_a] = { fqn: "cdk-extensions.kinesis_firehose.InputFormat", version: "0.0.38" };
class HiveJsonInputSerDe extends InputFormat {
    constructor(options = {}) {
        super();
        // Internal properties
        this._timestampFormats = [];
        options.timestampFormats?.forEach((x) => {
            this.addTimestampFormat(x);
        });
    }
    addTimestampFormat(format) {
        this._timestampFormats.push(format);
        return this;
    }
    bind(_scope) {
        return {
            deserializer: {
                hiveJsonSerDe: {
                    timestampFormats: aws_cdk_lib_1.Lazy.list({
                        produce: () => {
                            return this._timestampFormats;
                        },
                    }, {
                        omitEmpty: true,
                    }),
                },
            },
        };
    }
}
exports.HiveJsonInputSerDe = HiveJsonInputSerDe;
_b = JSII_RTTI_SYMBOL_1;
HiveJsonInputSerDe[_b] = { fqn: "cdk-extensions.kinesis_firehose.HiveJsonInputSerDe", version: "0.0.38" };
class OpenxJsonInputSerDe extends InputFormat {
    constructor(options = {}) {
        super();
        // Internal properties
        this._columnKeyMappings = {};
        this.caseInsensitive = options.caseInsensitive;
        this.convertDotsToUnderscores = options.convertDotsToUnderscores;
        if (options.columnKeyMappings) {
            const mapping = options.columnKeyMappings;
            Object.keys(mapping).forEach((x) => {
                this.addColumnKeyMapping(x, mapping[x]);
            });
        }
    }
    addColumnKeyMapping(columnName, jsonKey) {
        this._columnKeyMappings[columnName] = jsonKey;
        return this;
    }
    bind(_scope) {
        return {
            deserializer: {
                openXJsonSerDe: {
                    caseInsensitive: this.caseInsensitive,
                    columnToJsonKeyMappings: aws_cdk_lib_1.Lazy.any({
                        produce: () => {
                            return !!Object.keys(this._columnKeyMappings).length ? this._columnKeyMappings : undefined;
                        },
                    }),
                    convertDotsInJsonKeysToUnderscores: this.convertDotsToUnderscores,
                },
            },
        };
    }
}
exports.OpenxJsonInputSerDe = OpenxJsonInputSerDe;
_c = JSII_RTTI_SYMBOL_1;
OpenxJsonInputSerDe[_c] = { fqn: "cdk-extensions.kinesis_firehose.OpenxJsonInputSerDe", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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