"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParquetOutputSerDe = exports.OrcOutputSerDe = exports.OutputFormat = exports.ParquetWriterVersion = exports.ParquetCompressionFormat = exports.OrcFormatVersion = exports.OrcCompressionFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
var OrcCompressionFormat;
(function (OrcCompressionFormat) {
    OrcCompressionFormat["NONE"] = "NONE";
    OrcCompressionFormat["SNAPPY"] = "SNAPPY";
    OrcCompressionFormat["ZLIB"] = "ZLIB";
})(OrcCompressionFormat = exports.OrcCompressionFormat || (exports.OrcCompressionFormat = {}));
var OrcFormatVersion;
(function (OrcFormatVersion) {
    OrcFormatVersion["V0_11"] = "V0_11";
    OrcFormatVersion["V0_12"] = "V0_12";
})(OrcFormatVersion = exports.OrcFormatVersion || (exports.OrcFormatVersion = {}));
var ParquetCompressionFormat;
(function (ParquetCompressionFormat) {
    ParquetCompressionFormat["GZIP"] = "GZIP";
    ParquetCompressionFormat["SNAPPY"] = "SNAPPY";
    ParquetCompressionFormat["UNCOMPRESSED"] = "UNCOMPRESSED";
})(ParquetCompressionFormat = exports.ParquetCompressionFormat || (exports.ParquetCompressionFormat = {}));
var ParquetWriterVersion;
(function (ParquetWriterVersion) {
    ParquetWriterVersion["V1"] = "V1";
    ParquetWriterVersion["V2"] = "V2";
})(ParquetWriterVersion = exports.ParquetWriterVersion || (exports.ParquetWriterVersion = {}));
class OutputFormat {
    static orc(options) {
        return new OrcOutputSerDe(options);
    }
    static parquet(options) {
        return new ParquetOutputSerDe(options);
    }
}
exports.OutputFormat = OutputFormat;
_a = JSII_RTTI_SYMBOL_1;
OutputFormat[_a] = { fqn: "cdk-extensions.kinesis_firehose.OutputFormat", version: "0.0.38" };
class OrcOutputSerDe extends OutputFormat {
    constructor(options = {}) {
        super();
        // Internal properties
        this._bloomFilterColumns = [];
        this.blockSizeBytes = options.blockSizeBytes;
        this.bloomFilterFalsePositiveProbability = options.bloomFilterFalsePositiveProbability;
        this.compression = options.compression;
        this.dictionaryKeyThreshold = options.dictionaryKeyThreshold;
        this.enablePadding = options.enablePadding;
        this.formatVersion = options.formatVersion;
        this.paddingTolerance = options.paddingTolerance;
        this.rowIndexStride = options.rowIndexStride;
        this.stripeSizeBytes = options.stripeSizeBytes;
    }
    addBloomFilterColumn(column) {
        this._bloomFilterColumns.push(column);
        return this;
    }
    bind(_scope) {
        return {
            serializer: {
                orcSerDe: {
                    blockSizeBytes: this.blockSizeBytes,
                    bloomFilterColumns: aws_cdk_lib_1.Lazy.list({
                        produce: () => {
                            return this._bloomFilterColumns;
                        },
                    }, {
                        omitEmpty: true,
                    }),
                    bloomFilterFalsePositiveProbability: this.bloomFilterFalsePositiveProbability,
                    compression: this.compression,
                    dictionaryKeyThreshold: this.dictionaryKeyThreshold,
                    enablePadding: this.enablePadding,
                    formatVersion: this.formatVersion,
                    paddingTolerance: this.paddingTolerance,
                    rowIndexStride: this.rowIndexStride,
                    stripeSizeBytes: this.stripeSizeBytes,
                },
            },
        };
    }
}
exports.OrcOutputSerDe = OrcOutputSerDe;
_b = JSII_RTTI_SYMBOL_1;
OrcOutputSerDe[_b] = { fqn: "cdk-extensions.kinesis_firehose.OrcOutputSerDe", version: "0.0.38" };
class ParquetOutputSerDe extends OutputFormat {
    constructor(options = {}) {
        super();
        this.blockSizeBytes = options.blockSizeBytes;
        this.compression = options.compression;
        this.enableDictionaryCompression = options.enableDictionaryCompression;
        this.maxPaddingBytes = options.maxPaddingBytes;
        this.pageSizeBytes = options.pageSizeBytes;
        this.writerVersion = options.writerVersion;
    }
    bind(_scope) {
        return {
            serializer: {
                parquetSerDe: {
                    blockSizeBytes: this.blockSizeBytes,
                    compression: this.compression,
                    enableDictionaryCompression: this.enableDictionaryCompression,
                    maxPaddingBytes: this.maxPaddingBytes,
                    pageSizeBytes: this.pageSizeBytes,
                    writerVersion: this.writerVersion,
                },
            },
        };
    }
}
exports.ParquetOutputSerDe = ParquetOutputSerDe;
_c = JSII_RTTI_SYMBOL_1;
ParquetOutputSerDe[_c] = { fqn: "cdk-extensions.kinesis_firehose.ParquetOutputSerDe", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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