import { Duration } from 'aws-cdk-lib';
import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { IConstruct } from 'constructs';
import { DeliveryStreamProcessor } from './processors/delivery-stream-processor';
export interface CommonPartitioningOptions {
    readonly enabled?: boolean;
    readonly retryInterval?: Duration;
}
export interface JsonPartitioningOptions extends CommonPartitioningOptions {
    readonly partitions: {
        [name: string]: string;
    };
}
export interface LambdaPartitioningOptions extends CommonPartitioningOptions {
    readonly lambdaFunction: IFunction;
}
export interface DynamicPartitioningConfiguration {
    readonly partitioningConfiguration: CfnDeliveryStream.DynamicPartitioningConfigurationProperty;
    readonly processors?: DeliveryStreamProcessor[];
}
export declare class DynamicPartitioning {
    static fromJson(options: JsonPartitioningOptions): JsonPartitioningSource;
    static fromLambda(options: LambdaPartitioningOptions): LambdaPartitioningSource;
    readonly enabled: boolean;
    readonly retryInterval?: Duration;
    protected constructor(options: CommonPartitioningOptions);
    bind(_scope: IConstruct): DynamicPartitioningConfiguration;
}
export declare class JsonPartitioningSource extends DynamicPartitioning {
    private readonly _partitions;
    private readonly _query;
    constructor(options: JsonPartitioningOptions);
    addPartition(name: string, query: string): void;
    bind(scope: IConstruct): DynamicPartitioningConfiguration;
}
export declare class LambdaPartitioningSource extends DynamicPartitioning {
    readonly lambdaFunction: IFunction;
    constructor(options: LambdaPartitioningOptions);
    bind(scope: IConstruct): DynamicPartitioningConfiguration;
}
