import { ICertificate } from 'aws-cdk-lib/aws-certificatemanager';
import { IHostedZone } from 'aws-cdk-lib/aws-route53';
import { IConstruct } from 'constructs';
export declare enum DomainDiscovery {
    ALL = "ALL",
    NONE = "NONE",
    PRIVATE = "PRIVATE",
    PUBLIC = "PUBLIC"
}
export interface IDnsResolvable extends IConstruct {
    readonly domainDiscovery: DomainDiscovery;
    registerDomain(domain: Domain): void;
}
export interface DomainOptions {
    readonly certificate?: ICertificate;
    readonly subdomain?: string;
}
export declare class DomainManager {
    static isDnsResolvable(node: IConstruct): node is IDnsResolvable;
}
export declare class Domain {
    readonly certificate?: ICertificate;
    readonly isPublic: boolean;
    readonly subdomain?: string;
    readonly zone: IHostedZone;
    readonly zoneName: string;
    get fqdn(): string;
    constructor(zone: IHostedZone, isPublic: boolean, options?: DomainOptions);
    visit(node: IConstruct): void;
    private shouldRegister;
}
export declare class Domains {
    private readonly scope;
    static readonly ROOT: string;
    static of(scope: IConstruct): Domains;
    private constructor();
    add(hostedZone: IHostedZone, isPublic: boolean, options?: DomainOptions): void;
}
