"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domains = exports.Domain = exports.DomainManager = exports.DomainDiscovery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
var DomainDiscovery;
(function (DomainDiscovery) {
    DomainDiscovery["ALL"] = "ALL";
    DomainDiscovery["NONE"] = "NONE";
    DomainDiscovery["PRIVATE"] = "PRIVATE";
    DomainDiscovery["PUBLIC"] = "PUBLIC";
})(DomainDiscovery = exports.DomainDiscovery || (exports.DomainDiscovery = {}));
class DomainManager {
    static isDnsResolvable(node) {
        return ((node.domainDiscovery !== undefined) &&
            (node.registerDomain !== undefined));
    }
}
exports.DomainManager = DomainManager;
_a = JSII_RTTI_SYMBOL_1;
DomainManager[_a] = { fqn: "cdk-extensions.route53.DomainManager", version: "0.0.38" };
class Domain {
    constructor(zone, isPublic, options = {}) {
        this.certificate = options.certificate;
        this.isPublic = isPublic;
        this.subdomain = options.subdomain;
        this.zone = zone;
        this.zoneName = zone.zoneName;
    }
    get fqdn() {
        return this.subdomain ? `${this.subdomain}.${this.zoneName}` : this.zoneName;
    }
    visit(node) {
        if (DomainManager.isDnsResolvable(node) && this.shouldRegister(node)) {
            node.registerDomain(this);
        }
    }
    shouldRegister(node) {
        if (node.domainDiscovery === DomainDiscovery.ALL) {
            return true;
        }
        else if (node.domainDiscovery === DomainDiscovery.PUBLIC && this.isPublic) {
            return true;
        }
        else if (node.domainDiscovery === DomainDiscovery.PRIVATE && !this.isPublic) {
            return true;
        }
        else {
            return false;
        }
    }
}
exports.Domain = Domain;
_b = JSII_RTTI_SYMBOL_1;
Domain[_b] = { fqn: "cdk-extensions.route53.Domain", version: "0.0.38" };
class Domains {
    constructor(scope) {
        this.scope = scope;
    }
    static of(scope) {
        return new Domains(scope);
    }
    add(hostedZone, isPublic, options = {}) {
        aws_cdk_lib_1.Aspects.of(this.scope).add(new Domain(hostedZone, isPublic, options));
    }
}
exports.Domains = Domains;
_c = JSII_RTTI_SYMBOL_1;
Domains[_c] = { fqn: "cdk-extensions.route53.Domains", version: "0.0.38" };
Domains.ROOT = '::ROOT::';
//# sourceMappingURL=data:application/json;base64,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