"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ForwardResolverRule = void 0;
const resolver_rule_1 = require("./resolver-rule");
class ForwardResolverRule extends resolver_rule_1.ResolverRule {
    /**
       * Creates a new instance of the SystemResolverRule class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            domainName: props.domainName,
            resolverEndpoint: props.resolverEndpoint,
            ruleName: props.ruleName,
            ruleType: resolver_rule_1.ResolverRuleType.FORWARD,
            targetIps: props.targetIps,
        });
    }
}
exports.ForwardResolverRule = ForwardResolverRule;
//# sourceMappingURL=data:application/json;base64,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