"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolverRuleAssociation = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_route53resolver_1 = require("aws-cdk-lib/aws-route53resolver");
class ResolverRuleAssociation extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the ResolverRule class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.name = props.name;
        this.resolverRule = props.resolverRule;
        this.vpc = props.vpc;
        this.resource = new aws_route53resolver_1.CfnResolverRuleAssociation(this, 'Resource', {
            name: this.name,
            resolverRuleId: this.resolverRule.resolverRuleId,
            vpcId: this.vpc.vpcId,
        });
        this.resolverRuleAssociationId = this.resource.attrResolverRuleAssociationId;
        this.resolverRuleAssociationName = this.resource.attrName;
        this.resolverRuleAssociationResolverRuleId = this.resource.attrResolverRuleId;
        this.resolverRuleAssociationVpcId = this.resource.attrVpcId;
    }
}
exports.ResolverRuleAssociation = ResolverRuleAssociation;
//# sourceMappingURL=data:application/json;base64,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