"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemResolverRule = void 0;
const resolver_rule_1 = require("./resolver-rule");
class SystemResolverRule extends resolver_rule_1.ResolverRule {
    /**
       * Creates a new instance of the SystemResolverRule class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            /**
             * {@link SystemResolverRuleProps.domainName}
             */
            domainName: props.domainName,
            /**
             * {@link SystemResolverRuleProps.ruleName}
             */
            ruleName: props.ruleName,
            /**
             * {@link aws-route53resolver.ResolverRuleType.SYSTEM}
             */
            ruleType: resolver_rule_1.ResolverRuleType.SYSTEM,
        });
    }
}
exports.SystemResolverRule = SystemResolverRule;
//# sourceMappingURL=data:application/json;base64,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