import { ResourceProps } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
import { FlowLogFormat } from '../ec2';
import { Crawler, Database } from '../glue';
import { FlowLogsTable } from '../glue-tables';
import { RawBucket } from './private/raw-bucket';
/**
 * Configuration for objects bucket
 */
export interface FlowLogsBucketProps extends ResourceProps {
    readonly bucketName?: string;
    readonly crawlerSchedule?: Schedule;
    readonly createQueries?: boolean;
    readonly database?: Database;
    readonly format?: FlowLogFormat;
    readonly friendlyQueryNames?: boolean;
    readonly tableName?: string;
}
export declare class FlowLogsBucket extends RawBucket {
    readonly crawlerSchedule?: Schedule;
    readonly createQueries?: boolean;
    readonly format: FlowLogFormat;
    readonly friendlyQueryNames?: boolean;
    readonly crawler: Crawler;
    readonly database: Database;
    readonly table: FlowLogsTable;
    /**
       * Creates a new instance of the FlowLogsBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props?: FlowLogsBucketProps);
}
