"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlowLogsBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const ec2_1 = require("../ec2");
const glue_1 = require("../glue");
const glue_tables_1 = require("../glue-tables");
const raw_bucket_1 = require("./private/raw-bucket");
class FlowLogsBucket extends raw_bucket_1.RawBucket {
    /**
       * Creates a new instance of the FlowLogsBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            bucketEncryption: {
                serverSideEncryptionConfiguration: [
                    {
                        serverSideEncryptionByDefault: {
                            sseAlgorithm: 'AES256',
                        },
                    },
                ],
            },
            bucketName: props.bucketName ?? aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            publicAccessBlockConfiguration: {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            },
            versioningConfiguration: {
                status: 'Enabled',
            },
        });
        this.crawlerSchedule = props.crawlerSchedule ?? aws_events_1.Schedule.cron({
            hour: '0',
            minute: '5',
        });
        this.createQueries = props.createQueries;
        this.format = props.format ?? ec2_1.FlowLogFormat.V2;
        this.friendlyQueryNames = props.friendlyQueryNames;
        this.database = props.database ?? new glue_1.Database(this, 'database', {
            description: 'Database for storing flow log information',
        });
        this.table = new glue_tables_1.FlowLogsTable(this, 'table', {
            bucket: this,
            createQueries: this.createQueries,
            database: this.database,
            format: this.format,
            friendlyQueryNames: this.friendlyQueryNames,
            name: props.tableName,
        });
        this.crawler = new glue_1.Crawler(this, 'crawler', {
            configuration: {
                partitionUpdateBehavior: glue_1.PartitionUpdateBehavior.INHERIT_FROM_TABLE,
                version: glue_1.ConfigurationVersion.V1_0,
            },
            database: this.database,
            description: `Crawls the ${this.bucketName} bucket for Flow Logs.`,
            scheduleExpression: this.crawlerSchedule,
            targets: [
                new glue_1.S3Target(this, {
                    keyPrefix: 'AWSLogs/',
                }),
            ],
            updateBehavior: glue_1.UpdateBehavior.LOG,
        });
    }
}
exports.FlowLogsBucket = FlowLogsBucket;
_a = JSII_RTTI_SYMBOL_1;
FlowLogsBucket[_a] = { fqn: "cdk-extensions.s3_buckets.FlowLogsBucket", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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