"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3AccessLogsBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const glue_1 = require("../glue");
const glue_tables_1 = require("../glue-tables");
const raw_bucket_1 = require("./private/raw-bucket");
class S3AccessLogsBucket extends raw_bucket_1.RawBucket {
    /**
       * Creates a new instance of the S3AccessLogsBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            bucketEncryption: {
                serverSideEncryptionConfiguration: [
                    {
                        serverSideEncryptionByDefault: {
                            sseAlgorithm: 'AES256',
                        },
                    },
                ],
            },
            bucketName: props.bucketName ?? aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            publicAccessBlockConfiguration: {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            },
            versioningConfiguration: {
                status: 'Enabled',
            },
        });
        this.createQueries = props.createQueries;
        this.friendlyQueryNames = props.friendlyQueryNames;
        this.database = props.database ?? new glue_1.Database(this, 'database', {
            description: 'Database for storing S3 access logs',
        });
        this.table = new glue_tables_1.S3AccessLogsTable(this, 'table', {
            bucket: this,
            createQueries: this.createQueries,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            name: props.tableName,
        });
    }
    addLoggingAspect(scope, options) {
        const aspectAccounts = new Set();
        aws_cdk_lib_1.Aspects.of(scope).add({
            visit: (node) => {
                if (node instanceof aws_s3_1.CfnBucket && node !== this.resource && !options?.exclusions?.includes(node)) {
                    if (!node.loggingConfiguration || options?.force) {
                        node.loggingConfiguration = {
                            destinationBucketName: this.bucketName,
                            logFilePrefix: options?.prefix,
                        };
                        const account = aws_cdk_lib_1.Token.isUnresolved(node.stack.account) ? this.stack.account : node.stack.account;
                        const addStatement = aspectAccounts.size === 0;
                        aspectAccounts.add(account);
                        if (addStatement) {
                            this.addToResourcePolicy(new aws_iam_1.PolicyStatement({
                                actions: [
                                    's3:PutObject',
                                ],
                                conditions: {
                                    StringEquals: {
                                        'aws:SourceAccount': aws_cdk_lib_1.Lazy.list({
                                            produce: () => {
                                                return [...aspectAccounts];
                                            },
                                        }),
                                    },
                                },
                                effect: aws_iam_1.Effect.ALLOW,
                                principals: [
                                    new aws_iam_1.ServicePrincipal('logging.s3.amazonaws.com'),
                                ],
                                resources: [
                                    this.arnForObjects(`${options?.prefix ?? ''}*`),
                                ],
                            }));
                        }
                    }
                }
            },
        });
    }
}
exports.S3AccessLogsBucket = S3AccessLogsBucket;
_a = JSII_RTTI_SYMBOL_1;
S3AccessLogsBucket[_a] = { fqn: "cdk-extensions.s3_buckets.S3AccessLogsBucket", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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