import { ResourceProps } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { Database } from '../glue';
import { SesLogsTable } from '../glue-tables';
import { RawBucket } from './private/raw-bucket';
/**
 * Configuration for objects bucket
 */
export interface SesLogsBucketProps extends ResourceProps {
    readonly bucketName?: string;
    readonly createQueries?: boolean;
    readonly database?: Database;
    readonly friendlyQueryNames?: boolean;
    readonly tableName?: string;
}
export declare class SesLogsBucket extends RawBucket {
    readonly database: Database;
    readonly table: SesLogsTable;
    readonly createQueries?: boolean;
    readonly friendlyQueryNames?: boolean;
    /**
       * Creates a new instance of the CloudtrailBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props?: SesLogsBucketProps);
}
