"use strict";
/*import { Duration, Lazy, Resource, ResourceProps } from "aws-cdk-lib";
import { IRole } from "aws-cdk-lib/aws-iam";
import { IKey } from "aws-cdk-lib/aws-kms";
import { BlockPublicAccess, BucketAccessControl, CfnBucket, CorsRule, IBucket } from "aws-cdk-lib/aws-s3";
import { IConstruct } from "constructs";
import { definedFieldsOrUndefined } from "../../utils/formatting";
import { BucketEncryption } from "./lib/bucket-encryption";
import { CorsRuleConfiguration } from "./lib/cors-rule";


export enum Acceleration {
    DISABLED = 'Disabled',
    ENABLED = 'Enabled',
    SUSPENDED = 'Suspended'
}

export interface AccessLogging {
    readonly bucket: IBucket;
    readonly prefix?: string;
}

export enum ObjectLockMode {
    COMPLIANCE = 'COMPLIANCE',
    GOVERNANCE = 'GOVERNANCE'
}

export interface ObjectLock {
    readonly retention: Duration;
    readonly mode: ObjectLockMode
}

export enum ObjectOwnership {
    BUCKET_OWNER_ENFORCED = 'BucketOwnerEnforced',
    BUCKET_OWNER_PREFERRED = 'BucketOwnerPreferred',
    OBJECT_WRITER = 'ObjectWriter'
}

export interface BucketProps extends ResourceProps {
    readonly acceleration?: Acceleration;
    readonly accessControl?: BucketAccessControl;
    readonly accessLogging?: AccessLogging;
    readonly blockPublicAccess?: BlockPublicAccess;
    readonly cors?: CorsRuleConfiguration[];
    readonly encryption?: BucketEncryption;
    readonly name?: string;
    readonly objectLock?: ObjectLock;
    readonly objectOwnership?: ObjectOwnership;
    readonly versioned?: boolean;
}

export class Bucket extends Resource implements IBucket {
    // Internal properties
    private readonly _cors: CorsRuleConfiguration[] = [];
    private  _replicationRole?: IRole;

    // Input properties
    public readonly acceleration?: Acceleration;
    public readonly accessControl?: BucketAccessControl;
    public readonly accessLogging?: AccessLogging;
    public readonly blockPublicAccess?: BlockPublicAccess;
    public readonly cors?: CorsRuleConfiguration[];
    public readonly encryption?: BucketEncryption;
    public readonly name?: string;
    public readonly objectLock?: ObjectLock;
    public readonly objectOwnership?: ObjectOwnership;
    public readonly versioned?: boolean;

    // Resource properties
    public readonly encryptionKey?: IKey;
    public readonly resource: CfnBucket;

    // Resource accessors
    public get replicationRole(): IRole {
        return this._replicationRole;
    }


    public constructor(scope: IConstruct, id: string, props: BucketProps = {}) {
        super(scope, id, props);

        this.acceleration = props.acceleration;
        this.accessControl = props.accessControl;
        this.accessLogging = props.accessLogging;
        this.blockPublicAccess = props.blockPublicAccess;
        this.encryption = props.encryption;
        this.name = props.name;
        this.objectLock = props.objectLock;
        this.objectOwnership = props.objectOwnership;
        this.versioned = props.versioned;

        const encryptionConfiguration = this.encryption?.bind(this);
        this.encryptionKey = encryptionConfiguration?.encryptionKey;

        this.resource = new CfnBucket(this, 'Resource', {
            accelerateConfiguration: (this.acceleration ?? Acceleration.DISABLED) === Acceleration.DISABLED ? undefined : {
                accelerationStatus: this.acceleration
            },
            accessControl: ,
            analyticsConfigurations: ,
            bucketEncryption: encryptionConfiguration?.encryptionSettings,
            bucketName: this.name,
            corsConfiguration: Lazy.any({
                produce: () => {
                    return this.renderCors();
                }
            }),
            intelligentTieringConfigurations: ,
            inventoryConfigurations: ,
            lifecycleConfiguration: ,
            loggingConfiguration: !this.accessLogging ? undefined : {
                destinationBucketName: this.accessLogging.bucket.bucketName,
                logFilePrefix: this.accessLogging.prefix
            },
            metricsConfigurations: ,
            notificationConfiguration: ,
            objectLockConfiguration: !this.objectLock ? undefined : {
                objectLockEnabled: 'Enabled',
                rule: {
                    defaultRetention: {
                        days: this.objectLock.retention.toDays(),
                        mode: this.objectLock.mode
                    }
                }
            },
            objectLockEnabled: !!this.objectLock,
            ownershipControls: !this.objectOwnership ? undefined : {
                rules: [
                    {
                        objectOwnership: this.objectOwnership
                    }
                ]
            },
            publicAccessBlockConfiguration: definedFieldsOrUndefined({
                blockPublicAcls: this.blockPublicAccess.blockPublicAcls,
                blockPublicPolicy: this.blockPublicAccess.blockPublicPolicy,
                ignorePublicAcls: this.blockPublicAccess.ignorePublicAcls,
                restrictPublicBuckets: this.blockPublicAccess.restrictPublicBuckets
            }),
            replicationConfiguration: ,
            versioningConfiguration: !this.versioned ? undefined : {
                status: 'Enabled'
            },
            websiteConfiguration:
        });
    }

    public addCorsRule(rule: CorsRuleConfiguration): Bucket {
        this._cors.push(rule);
        return this;
    }

    protected renderCors(): CfnBucket.CorsConfigurationProperty | undefined {
        if (this._cors.length === 0) {
            return undefined;
        }

        return {
            corsRules: this._cors.map((x) => {
                return {
                    allowedHeaders: x.allowedHeaders,
                    allowedMethods: x.allowedMethods,
                    allowedOrigins: x.allowedOrigins,
                    exposedHeaders: x.exposedHeaders,
                    id: x.id,
                    maxAge: x.maxAge.toSeconds()
                }
            })
        };
    }

    protected renderReplication(): CfnBucket.ReplicationConfigurationProperty | undefined {

    }
}*/ 
//# sourceMappingURL=data:application/json;base64,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