import { IKey } from 'aws-cdk-lib/aws-kms';
import { CfnBucket } from 'aws-cdk-lib/aws-s3';
import { IConstruct } from 'constructs';
/**
 * Algorithms for enabling at rest encryption on S3 buckets.
 */
export declare enum BucketEncryptionAlgorithm {
    /**
       * Encrypt files using S3.
       */
    KMS = "aws:kms",
    /**
       * Encrypt files using S3 managed AES256 encryption.
       */
    AES256 = "AES256"
}
export interface KmsEncryptionOptions {
    readonly bucketKeyEnabled?: boolean;
    readonly encryptionKey?: IKey;
}
export interface BucketEncryptionConfiguration {
    readonly encryptionKey?: IKey;
    readonly encryptionSettings?: CfnBucket.BucketEncryptionProperty;
}
export declare class BucketEncryption {
    static readonly KMS: BucketEncryption;
    static readonly KMS_MANAGED: BucketEncryption;
    static readonly S3_MANAGED: BucketEncryption;
    static readonly UNENCRYPTED: BucketEncryption;
    static kms(options: KmsEncryptionOptions): BucketEncryption;
    readonly algorithm?: BucketEncryptionAlgorithm;
    readonly bucketKeyEnabled?: boolean;
    readonly encryptionKey?: IKey;
    readonly generateKey?: boolean;
    private constructor();
    bind(scope: IConstruct): BucketEncryptionConfiguration;
}
