"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Assignment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_sso_1 = require("aws-cdk-lib/aws-sso");
/**
 * Assigns access to a Principal for a specified AWS account using a specified
 * permission set.
 */
class Assignment extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the Assignment class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in
       * the construct tree.
       * @param id A name to be associated with the stack and used in resource
       * naming. Must be unique within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.instance = props.instance;
        this.permissionSet = props.permissionSet;
        this.principal = props.principal;
        this.target = props.target;
        this.resource = new aws_sso_1.CfnAssignment(this, 'Resource', {
            instanceArn: this.instance.instanceArn,
            permissionSetArn: this.permissionSet.permissionSetArn,
            principalId: this.principal.principalId,
            principalType: this.principal.principalType.name,
            targetId: this.target.targetId,
            targetType: this.target.targetType.name,
        });
    }
}
exports.Assignment = Assignment;
_a = JSII_RTTI_SYMBOL_1;
Assignment[_a] = { fqn: "cdk-extensions.sso.Assignment", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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