import { Resource, ResourceProps } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { IdentityCenterPrincipalType, IIdentityCenterPrincipal } from './lib/identity-center-principal';
export interface IGroup {
    /**
     * A GUID identifier for a group object in IAM Identity Center are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
     */
    readonly groupId: string;
}
export declare abstract class GroupBase extends Resource implements IGroup, IIdentityCenterPrincipal {
    readonly abstract groupId: string;
    readonly abstract principalId: string;
    readonly principalType: IdentityCenterPrincipalType;
    constructor(scope: IConstruct, id: string, props?: ResourceProps);
}
export declare class Group {
    static fromGroupId(scope: IConstruct, id: string, groupId: string): IGroup;
}
