"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Group = exports.GroupBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const identity_center_principal_1 = require("./lib/identity-center-principal");
class GroupBase extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.principalType = identity_center_principal_1.IdentityCenterPrincipalType.GROUP;
    }
}
exports.GroupBase = GroupBase;
_a = JSII_RTTI_SYMBOL_1;
GroupBase[_a] = { fqn: "cdk-extensions.sso.GroupBase", version: "0.0.38" };
class Group {
    static fromGroupId(scope, id, groupId) {
        class Import extends GroupBase {
            constructor() {
                super(scope, id);
                this.groupId = groupId;
                this.principalId = groupId;
            }
        }
        return new Import();
    }
}
exports.Group = Group;
_b = JSII_RTTI_SYMBOL_1;
Group[_b] = { fqn: "cdk-extensions.sso.Group", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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