"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceAccessControlAttributeConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_sso_1 = require("aws-cdk-lib/aws-sso");
const access_control_attribute_1 = require("./lib/access-control-attribute");
/**
 * Enables the attribute-based access control (ABAC) feature for the specified
 * IAM Identity Center instance. You can also specify new attributes to add to
 * your ABAC configuration during the enabling process. For more information
 * about ABAC, see [Attribute-Based Access Control](https://docs.aws.amazon.com/singlesignon/latest/userguide/abac.html) in the IAM Identity Center
 * User Guide.
 */
class InstanceAccessControlAttributeConfiguration extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the
       * InstanceAccessControlAttributeConfiguration class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in
       * the construct tree.
       * @param id A name to be associated with the stack and used in resource
       * naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Internal properties
        this._attributes = [];
        this.instance = props.instance;
        this.resource = new aws_sso_1.CfnInstanceAccessControlAttributeConfiguration(this, 'Resource', {
            instanceArn: this.instance.instanceArn,
            accessControlAttributes: aws_cdk_lib_1.Lazy.any({
                produce: () => {
                    this._attributes.map((x) => {
                        return x.bind(this);
                    });
                },
            }, {
                omitEmptyArray: true,
            }),
        });
    }
    // Standard accessors
    /**
       * Lists the attributes that are configured for ABAC in the specified IAM
       * Identity Center instance. This array is readonly. Changes made to the
       * array will not be reflected in this resource. To add new attributes use
       * the `{@link addAttribute}` method.
       */
    get attributes() {
        return [...this._attributes];
    }
    /**
       * Adds a new ABAC attribute in the specified IAM Identity Center instance.
       *
       * @param key The name of the attribute associated with your identities in
       * your identity source. This is used to map a specified attribute in your
       * identity source with an attribute in IAM Identity Center.
       * @param sources The identity sources to use when mapping a specified
       * attribute to IAM Identity Center.
       * @returns An AccessControlAttribute resource that will be applied to the
       * configuration and supports continued management.
       */
    addAttribute(key, ...sources) {
        const attribute = new access_control_attribute_1.AccessControlAttribute({
            name: key,
            sources: sources,
        });
        this._attributes.push(attribute);
        return attribute;
    }
}
exports.InstanceAccessControlAttributeConfiguration = InstanceAccessControlAttributeConfiguration;
_a = JSII_RTTI_SYMBOL_1;
InstanceAccessControlAttributeConfiguration[_a] = { fqn: "cdk-extensions.sso.InstanceAccessControlAttributeConfiguration", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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