import { Resource } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
export interface IInstance {
    /**
     * The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and AWS Service Namespaces in the AWS General Reference.
     *
     * @see [AWS::SSO::Assignment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-assignment.html#cfn-sso-assignment-instancearn)
     */
    readonly instanceArn: string;
    /**
     * The ID of the IAM Identity Center instance under which the operation will be executed.
     */
    readonly instanceId: string;
}
export declare abstract class InstanceBase extends Resource implements IInstance {
    readonly abstract instanceArn: string;
    readonly abstract instanceId: string;
}
export declare class Instance {
    static fromArn(scope: IConstruct, id: string, arn: string): IInstance;
    static fromInstanceId(scope: IConstruct, id: string, instanceId: string): IInstance;
}
