"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class InstanceBase extends aws_cdk_lib_1.Resource {
}
exports.InstanceBase = InstanceBase;
_a = JSII_RTTI_SYMBOL_1;
InstanceBase[_a] = { fqn: "cdk-extensions.sso.InstanceBase", version: "0.0.38" };
class Instance {
    static fromArn(scope, id, arn) {
        class Import extends InstanceBase {
            constructor() {
                super(scope, id);
                this.instanceArn = arn;
                this.instanceId = aws_cdk_lib_1.Token.isUnresolved(arn) ? aws_cdk_lib_1.Fn.select(1, aws_cdk_lib_1.Fn.split('/', arn, 2)) : arn.split('/')[1];
            }
        }
        return new Import();
    }
    static fromInstanceId(scope, id, instanceId) {
        return Instance.fromArn(scope, id, aws_cdk_lib_1.Stack.of(scope).formatArn({
            account: '',
            region: '',
            resource: 'instance',
            resourceName: instanceId,
            service: 'sso',
        }));
    }
}
exports.Instance = Instance;
_b = JSII_RTTI_SYMBOL_1;
Instance[_b] = { fqn: "cdk-extensions.sso.Instance", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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