"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssignmentTarget = exports.AssignmentTargetType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Provides a wrapper around the accepted values for the IAM Identity Center
 * [Assignment.TargetType attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-assignment.html#cfn-sso-assignment-targettype).
 *
 * Accepted values are provided as static properties that can be used when
 * configuring an assignment.
 */
class AssignmentTargetType {
    /**
       * Creates a new instance of the AssignmentTargetType class.
       *
       * @param name The name of the target type.
       */
    constructor(name) {
        this.name = name;
    }
    /**
       * An escape hatch method that allows specifying a custom target type in
       * the even more options are added and the provided static types are yet to
       * catch up.
       *
       * It is recommended that the provided static types be used when possible
       * instead of calling `of`.
       *
       * @param name The name of the assignment target type.
       * @returns An {@link AssignmentTargetType} object representing the specified type.
       */
    static of(name) {
        return new AssignmentTargetType(name);
    }
}
exports.AssignmentTargetType = AssignmentTargetType;
_a = JSII_RTTI_SYMBOL_1;
AssignmentTargetType[_a] = { fqn: "cdk-extensions.sso.AssignmentTargetType", version: "0.0.38" };
/**
   * An AWS account.
   */
AssignmentTargetType.AWS_ACCOUNT = AssignmentTargetType.of('AWS_ACCOUNT');
/**
 * Represents a resource that can have permissions granted for using IAM
 * Identity Center such as an AWS account.
 */
class AssignmentTarget {
    /**
       * Creates a new instance of the AssignmentTarget class.
       *
       * @param targetType The entity type for which permissions will be granted.
       * @param targetId The unique identifier specifying the entity for which
       * permissions will be granted.
       */
    constructor(targetType, targetId) {
        this.targetId = targetId;
        this.targetType = targetType;
    }
    /**
       * Creates an assignment target that represents an AWS account.
       *
       * @param accountId The ID of the AWS account for which permissions should
       * be granted.
       * @returns An AssignmentTarget representing the AWS account.
       */
    static awsAccount(accountId) {
        return AssignmentTarget.of(AssignmentTargetType.AWS_ACCOUNT, accountId);
    }
    /**
       * An escape hatch method that allows specifying a custom target for an
       * assignment in the event new target options are added and the provided
       * methods for configuring targets are yet to catch up.
       *
       * It is recommended that the provided static methods be used whenever
       * possible for configuring assignment targets instead of calling `of`.
       *
       * @param targetType The entity type for which permissions will be granted.
       * @param targetId The unique identifier specifying the entity for which
       * permissions will be granted.
       * @returns
       */
    static of(targetType, targetId) {
        return new AssignmentTarget(targetType, targetId);
    }
}
exports.AssignmentTarget = AssignmentTarget;
_b = JSII_RTTI_SYMBOL_1;
AssignmentTarget[_b] = { fqn: "cdk-extensions.sso.AssignmentTarget", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzaWdubWVudC10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvc3NvL2xpYi9hc3NpZ25tZW50LXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBOzs7Ozs7R0FNRztBQUNILE1BQWEsb0JBQW9CO0lBMkIvQjs7OztTQUlLO0lBQ0wsWUFBb0IsSUFBWTtRQUM5QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNuQixDQUFDO0lBNUJEOzs7Ozs7Ozs7O1NBVUs7SUFDRSxNQUFNLENBQUMsRUFBRSxDQUFDLElBQVk7UUFDM0IsT0FBTyxJQUFJLG9CQUFvQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3hDLENBQUM7O0FBbkJILG9EQW1DQzs7O0FBbENDOztLQUVLO0FBQ2tCLGdDQUFXLEdBQXlCLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztBQWlDcEc7OztHQUdHO0FBQ0gsTUFBYSxnQkFBZ0I7SUF5QzNCOzs7Ozs7U0FNSztJQUNMLFlBQW9CLFVBQWdDLEVBQUUsUUFBZ0I7UUFDcEUsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7UUFDekIsSUFBSSxDQUFDLFVBQVUsR0FBRyxVQUFVLENBQUM7SUFDL0IsQ0FBQztJQWxERDs7Ozs7O1NBTUs7SUFDRSxNQUFNLENBQUMsVUFBVSxDQUFDLFNBQWlCO1FBQ3hDLE9BQU8sZ0JBQWdCLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLFdBQVcsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUMxRSxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztTQVlLO0lBQ0UsTUFBTSxDQUFDLEVBQUUsQ0FBQyxVQUFnQyxFQUFFLFFBQWdCO1FBQ2pFLE9BQU8sSUFBSSxnQkFBZ0IsQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFDcEQsQ0FBQzs7QUEzQkgsNENBb0RDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBQcm92aWRlcyBhIHdyYXBwZXIgYXJvdW5kIHRoZSBhY2NlcHRlZCB2YWx1ZXMgZm9yIHRoZSBJQU0gSWRlbnRpdHkgQ2VudGVyXG4gKiBbQXNzaWdubWVudC5UYXJnZXRUeXBlIGF0dHJpYnV0ZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNzby1hc3NpZ25tZW50Lmh0bWwjY2ZuLXNzby1hc3NpZ25tZW50LXRhcmdldHR5cGUpLlxuICpcbiAqIEFjY2VwdGVkIHZhbHVlcyBhcmUgcHJvdmlkZWQgYXMgc3RhdGljIHByb3BlcnRpZXMgdGhhdCBjYW4gYmUgdXNlZCB3aGVuXG4gKiBjb25maWd1cmluZyBhbiBhc3NpZ25tZW50LlxuICovXG5leHBvcnQgY2xhc3MgQXNzaWdubWVudFRhcmdldFR5cGUge1xuICAvKipcbiAgICAgKiBBbiBBV1MgYWNjb3VudC5cbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBV1NfQUNDT1VOVDogQXNzaWdubWVudFRhcmdldFR5cGUgPSBBc3NpZ25tZW50VGFyZ2V0VHlwZS5vZignQVdTX0FDQ09VTlQnKTtcblxuICAvKipcbiAgICAgKiBBbiBlc2NhcGUgaGF0Y2ggbWV0aG9kIHRoYXQgYWxsb3dzIHNwZWNpZnlpbmcgYSBjdXN0b20gdGFyZ2V0IHR5cGUgaW5cbiAgICAgKiB0aGUgZXZlbiBtb3JlIG9wdGlvbnMgYXJlIGFkZGVkIGFuZCB0aGUgcHJvdmlkZWQgc3RhdGljIHR5cGVzIGFyZSB5ZXQgdG9cbiAgICAgKiBjYXRjaCB1cC5cbiAgICAgKlxuICAgICAqIEl0IGlzIHJlY29tbWVuZGVkIHRoYXQgdGhlIHByb3ZpZGVkIHN0YXRpYyB0eXBlcyBiZSB1c2VkIHdoZW4gcG9zc2libGVcbiAgICAgKiBpbnN0ZWFkIG9mIGNhbGxpbmcgYG9mYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBuYW1lIFRoZSBuYW1lIG9mIHRoZSBhc3NpZ25tZW50IHRhcmdldCB0eXBlLlxuICAgICAqIEByZXR1cm5zIEFuIHtAbGluayBBc3NpZ25tZW50VGFyZ2V0VHlwZX0gb2JqZWN0IHJlcHJlc2VudGluZyB0aGUgc3BlY2lmaWVkIHR5cGUuXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YobmFtZTogc3RyaW5nKTogQXNzaWdubWVudFRhcmdldFR5cGUge1xuICAgIHJldHVybiBuZXcgQXNzaWdubWVudFRhcmdldFR5cGUobmFtZSk7XG4gIH1cblxuXG4gIC8qKlxuICAgICAqIFRoZSBuYW1lIGRlc2NyaWJpbmcgdGhlIHR5cGUgb2YgdGFyZ2V0LlxuICAgICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIENyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIEFzc2lnbm1lbnRUYXJnZXRUeXBlIGNsYXNzLlxuICAgICAqXG4gICAgICogQHBhcmFtIG5hbWUgVGhlIG5hbWUgb2YgdGhlIHRhcmdldCB0eXBlLlxuICAgICAqL1xuICBwcml2YXRlIGNvbnN0cnVjdG9yKG5hbWU6IHN0cmluZykge1xuICAgIHRoaXMubmFtZSA9IG5hbWU7XG4gIH1cbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgcmVzb3VyY2UgdGhhdCBjYW4gaGF2ZSBwZXJtaXNzaW9ucyBncmFudGVkIGZvciB1c2luZyBJQU1cbiAqIElkZW50aXR5IENlbnRlciBzdWNoIGFzIGFuIEFXUyBhY2NvdW50LlxuICovXG5leHBvcnQgY2xhc3MgQXNzaWdubWVudFRhcmdldCB7XG4gIC8qKlxuICAgICAqIENyZWF0ZXMgYW4gYXNzaWdubWVudCB0YXJnZXQgdGhhdCByZXByZXNlbnRzIGFuIEFXUyBhY2NvdW50LlxuICAgICAqXG4gICAgICogQHBhcmFtIGFjY291bnRJZCBUaGUgSUQgb2YgdGhlIEFXUyBhY2NvdW50IGZvciB3aGljaCBwZXJtaXNzaW9ucyBzaG91bGRcbiAgICAgKiBiZSBncmFudGVkLlxuICAgICAqIEByZXR1cm5zIEFuIEFzc2lnbm1lbnRUYXJnZXQgcmVwcmVzZW50aW5nIHRoZSBBV1MgYWNjb3VudC5cbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyBhd3NBY2NvdW50KGFjY291bnRJZDogc3RyaW5nKTogQXNzaWdubWVudFRhcmdldCB7XG4gICAgcmV0dXJuIEFzc2lnbm1lbnRUYXJnZXQub2YoQXNzaWdubWVudFRhcmdldFR5cGUuQVdTX0FDQ09VTlQsIGFjY291bnRJZCk7XG4gIH1cblxuICAvKipcbiAgICAgKiBBbiBlc2NhcGUgaGF0Y2ggbWV0aG9kIHRoYXQgYWxsb3dzIHNwZWNpZnlpbmcgYSBjdXN0b20gdGFyZ2V0IGZvciBhblxuICAgICAqIGFzc2lnbm1lbnQgaW4gdGhlIGV2ZW50IG5ldyB0YXJnZXQgb3B0aW9ucyBhcmUgYWRkZWQgYW5kIHRoZSBwcm92aWRlZFxuICAgICAqIG1ldGhvZHMgZm9yIGNvbmZpZ3VyaW5nIHRhcmdldHMgYXJlIHlldCB0byBjYXRjaCB1cC5cbiAgICAgKlxuICAgICAqIEl0IGlzIHJlY29tbWVuZGVkIHRoYXQgdGhlIHByb3ZpZGVkIHN0YXRpYyBtZXRob2RzIGJlIHVzZWQgd2hlbmV2ZXJcbiAgICAgKiBwb3NzaWJsZSBmb3IgY29uZmlndXJpbmcgYXNzaWdubWVudCB0YXJnZXRzIGluc3RlYWQgb2YgY2FsbGluZyBgb2ZgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHRhcmdldFR5cGUgVGhlIGVudGl0eSB0eXBlIGZvciB3aGljaCBwZXJtaXNzaW9ucyB3aWxsIGJlIGdyYW50ZWQuXG4gICAgICogQHBhcmFtIHRhcmdldElkIFRoZSB1bmlxdWUgaWRlbnRpZmllciBzcGVjaWZ5aW5nIHRoZSBlbnRpdHkgZm9yIHdoaWNoXG4gICAgICogcGVybWlzc2lvbnMgd2lsbCBiZSBncmFudGVkLlxuICAgICAqIEByZXR1cm5zXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YodGFyZ2V0VHlwZTogQXNzaWdubWVudFRhcmdldFR5cGUsIHRhcmdldElkOiBzdHJpbmcpOiBBc3NpZ25tZW50VGFyZ2V0IHtcbiAgICByZXR1cm4gbmV3IEFzc2lnbm1lbnRUYXJnZXQodGFyZ2V0VHlwZSwgdGFyZ2V0SWQpO1xuICB9XG5cblxuICAvKipcbiAgICAgKiBUaGUgdW5pcXVlIGlkZW50aWZpZXIgZm9yIHRoZSByZXNvdXJjZSBmb3Igd2hpY2ggcGVybWlzc2lvbnMgd2lsbCBiZVxuICAgICAqIGdyYW50ZWQuXG4gICAgICovXG4gIHB1YmxpYyByZWFkb25seSB0YXJnZXRJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIFRoZSB0eXBlIG9mIHJlc291cmNlIGZvciB3aGljaCBwZXJtaXNzaW9ucyB3aWxsIGJlIGdyYW50ZWQuXG4gICAgICovXG4gIHB1YmxpYyByZWFkb25seSB0YXJnZXRUeXBlOiBBc3NpZ25tZW50VGFyZ2V0VHlwZTtcblxuICAvKipcbiAgICAgKiBDcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBBc3NpZ25tZW50VGFyZ2V0IGNsYXNzLlxuICAgICAqXG4gICAgICogQHBhcmFtIHRhcmdldFR5cGUgVGhlIGVudGl0eSB0eXBlIGZvciB3aGljaCBwZXJtaXNzaW9ucyB3aWxsIGJlIGdyYW50ZWQuXG4gICAgICogQHBhcmFtIHRhcmdldElkIFRoZSB1bmlxdWUgaWRlbnRpZmllciBzcGVjaWZ5aW5nIHRoZSBlbnRpdHkgZm9yIHdoaWNoXG4gICAgICogcGVybWlzc2lvbnMgd2lsbCBiZSBncmFudGVkLlxuICAgICAqL1xuICBwcml2YXRlIGNvbnN0cnVjdG9yKHRhcmdldFR5cGU6IEFzc2lnbm1lbnRUYXJnZXRUeXBlLCB0YXJnZXRJZDogc3RyaW5nKSB7XG4gICAgdGhpcy50YXJnZXRJZCA9IHRhcmdldElkO1xuICAgIHRoaXMudGFyZ2V0VHlwZSA9IHRhcmdldFR5cGU7XG4gIH1cbn0iXX0=