"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoggingStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2_1 = require("../ec2");
const glue_1 = require("../glue");
const s3_buckets_1 = require("../s3-buckets");
/**
 * Creates a Stack that deploys a logging strategy for several AWS services.
 * Stack creates a Glue Database using cdk-extensions Database, deploys
 * cdk-extensions/s3-buckets patterns for each service, and utilizes methods exposed
 * by cdk-extensions/s3-buckets S3AccessLogsBucket to enable logging for each created
 * bucket.
 *
 * @see {@link aws-glue!Database | cdk-extensions/glue Database}
 * @see {@link aws-s3-buckets!AlbLogsBucket | cdk-extensions/s3-buckets AlbLogsBucket}
 * @see {@link aws-s3-buckets!CloudfrontLogsBucket | cdk-extensions/s3-buckets CloudfrontLogsBucket}
 * @see {@link aws-s3-buckets!CloudtrailBucket | cdk-extensions/s3-buckets CloudtrailBucket}
 * @see {@link aws-s3-buckets!FlowLogsBucket | cdk-extensions/s3-buckets FlowLogsBucket}
 * @see {@link aws-s3-buckets!S3AccessLogsBucket | cdk-extensions/s3-buckets S3AccessLogsBucket}
 * @see {@link aws-s3-buckets!SesLogsBucket | cdk-extensions/s3-buckets SesLogsBucket}
 * @see {@link aws-s3-buckets!WafLogsBucket | cdk-extensions/s3-buckets WafLogsBucket}
 */
class AwsLoggingStack extends aws_cdk_lib_1.Stack {
    /**
       * Creates a new instance of the AwsLoggingStack class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.databaseName = props.databaseName ?? 'awslogs';
        this.flowLogsFormat = props.flowLogsFormat ?? ec2_1.FlowLogFormat.V2;
        this.friendlyQueryNames = props.friendlyQueryNames ?? props.standardizeNames ?? true;
        this.standardizeNames = props.standardizeNames ?? true;
        this.database = new glue_1.Database(this, 'database', {
            name: this.databaseName,
        });
        this.s3AccessLogsBucket = new s3_buckets_1.S3AccessLogsBucket(this, 's3-access-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-s3-access-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 's3_access_logs',
        });
        this.albLogsBucket = props.albLogsBucket ?? new s3_buckets_1.AlbLogsBucket(this, 'alb-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-alb-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'alb_logs',
        });
        this.cloudfrontLogsBucket = props.cloudfrontLogsBucket ?? new s3_buckets_1.CloudfrontLogsBucket(this, 'cloudfront-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-cloudfront-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'cloudfront_logs',
        });
        this.cloudtrailLogsBucket = props.cloudtrailLogsBucket ?? new s3_buckets_1.CloudtrailBucket(this, 'cloudtail-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-cloudtrail-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'cloudtrail_logs',
        });
        this.flowLogsBucket = props.flowLogsBucket ?? new s3_buckets_1.FlowLogsBucket(this, 'flow-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-flow-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            format: this.flowLogsFormat,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'flow_logs',
        });
        this.sesLogsBucket = props.sesLogsBucket ?? new s3_buckets_1.SesLogsBucket(this, 'ses-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-ses-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'ses_logs',
        });
        this.wafLogsBucket = props.wafLogsBucket ?? new s3_buckets_1.WafLogsBucket(this, 'waf-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-waf-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'waf_logs',
        });
        this.s3AccessLogsBucket.addLoggingAspect(this);
    }
}
exports.AwsLoggingStack = AwsLoggingStack;
_a = JSII_RTTI_SYMBOL_1;
AwsLoggingStack[_a] = { fqn: "cdk-extensions.stacks.AwsLoggingStack", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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