# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-06-08 20:40
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangocms_text_ckeditor.fields
import multiselectfield.db.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("leprikon", "0061_refundrequest"),
    ]

    operations = [
        migrations.AddField(
            model_name="subject",
            name="text_registration_refund_offer",
            field=djangocms_text_ckeditor.fields.HTMLField(
                blank=True, default="", verbose_name="text: registration refund offer"
            ),
        ),
        migrations.AddField(
            model_name="subjectregistration",
            name="refund_offered",
            field=models.DateTimeField(editable=False, null=True, verbose_name="payment request time"),
        ),
        migrations.AddField(
            model_name="subjectregistration",
            name="refund_offered_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="payment requested by",
            ),
        ),
        migrations.AddField(
            model_name="subjecttype",
            name="text_registration_refund_offer",
            field=djangocms_text_ckeditor.fields.HTMLField(
                blank=True,
                default="",
                help_text="<p>Keep empty to use default value:</p><p>Hello,<br/>\nYour registration has been overpaid.<br/>\nPlease, tell us how you wish us to refund.</p>",
                verbose_name="text: registration refund offer",
            ),
        ),
        migrations.AlterField(
            model_name="subjectattachment",
            name="events",
            field=multiselectfield.db.fields.MultiSelectField(
                blank=True,
                choices=[
                    ("registration_received", "registration received"),
                    ("registration_approved", "registration approved"),
                    ("registration_refused", "registration refused"),
                    ("registration_payment_request", "payment requested"),
                    ("registration_refund_offer", "payment requested"),
                    ("registration_canceled", "registration canceled"),
                    ("discount_granted", "discount granted"),
                    ("payment_received", "payment received"),
                    ("payment_returned", "payment returned"),
                ],
                default=[],
                help_text="The attachment will be sent with notification on selected events.",
                max_length=192,
                verbose_name="send when",
            ),
        ),
        migrations.AlterField(
            model_name="subjecttypeattachment",
            name="events",
            field=multiselectfield.db.fields.MultiSelectField(
                blank=True,
                choices=[
                    ("registration_received", "registration received"),
                    ("registration_approved", "registration approved"),
                    ("registration_refused", "registration refused"),
                    ("registration_payment_request", "payment requested"),
                    ("registration_refund_offer", "payment requested"),
                    ("registration_canceled", "registration canceled"),
                    ("discount_granted", "discount granted"),
                    ("payment_received", "payment received"),
                    ("payment_returned", "payment returned"),
                ],
                default=[],
                help_text="The attachment will be sent with notification on selected events.",
                max_length=192,
                verbose_name="send when",
            ),
        ),
    ]
