# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mercado', 'mercado.vendors']

package_data = \
{'': ['*']}

install_requires = \
['humanize>=4.4.0,<5.0.0',
 'requests>=2.28.1,<3.0.0',
 'rich>=12.6.0,<13.0.0',
 'typer>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['mercado = mercado.cli:main']}

setup_kwargs = {
    'name': 'mercado',
    'version': '0.1.4',
    'description': 'All-In-One Development CLI Tools Multi-platform Marketplace',
    'long_description': '# Mercado\nAll-In-One Development CLI Tools Multi-platform Marketplace\n\nStop memorizing whether that\'s `apt install` or `brew` or any other package manager that takes too long whenever only to get an outdated tool - and use `mercado` instead!\n\nAll the most used tools by developers like `docker`, `terraform`, and `kubectl`.\n\n- Supports different types of installations\n  - **GitHub releases**\n  - **Hashicorp products**\n  - **URL fetching**\n  - **Customized shell scripts**\n- **Multi-platform multi-architectures** installations\n- Install the **latest artifact** or a specific version\n- HTTP calls with retry mechanismand timeouts\n- Archive unpacking\n- Elaborated logs with timestamps of every step in the process\n- CI first\n  - Every artifact is verified on a daily basis\n  - README is dynamically generated so docs can\'t get broken\n\n\n## Supported Tools\n\n<!-- [[[cog\nimport cog\nfrom textwrap import dedent\nimport subprocess\n\ndef print_command(command):\n    cog.outl(dedent(f"""\n```bash\n$ mercado {command}\n\n{subprocess.getoutput(f"./main.py {command}")}\n```\n    """))\n\nprint_command("list --names-only")\n\n]]] -->\n\n```bash\n$ mercado list --names-only\n\nMercado tools \n┏━━━━━━━━━━━━┓\n┃ Name       ┃\n┡━━━━━━━━━━━━┩\n│ compose    │\n│ consul     │\n│ cosign     │\n│ docker     │\n│ gh         │\n│ helm       │\n│ k3d        │\n│ kind       │\n│ kubectl    │\n│ minikube   │\n│ packer     │\n│ terraform  │\n│ terragrunt │\n│ tfsec      │\n│ trivy      │\n│ vagrant    │\n│ vault      │\n│ waypoint   │\n└────────────┘\n```\n\n<!-- [[[end]]] -->\n\n## Install\n\n```bash\npython -m pip install mercado\n```\n\n## How to use\n\n<!-- [[[cog\nimport cog\nfrom textwrap import dedent\nimport subprocess\n\ndef print_command(command):\n    cog.outl(dedent(f"""\n```bash\n$ {command}\n\n{subprocess.getoutput(command)}\n```\n    """))\n\nprint_command("mercado install gh")\n\nprint_command("mercado is-latest docker")\n\nprint_command("mercado show minikube")\n\nprint_command("mercado list --label k8s --with-labels")\n\nprint_command("mercado list --installed-only --verbose")\n\n]]] -->\n\n```bash\n$ mercado install gh\n\n[12/10/22 04:16:21] Looking for the latest version of \'gh\'                                                                                                       \n[12/10/22 04:16:22] Getting installer for tool \'gh\' with version v2.20.2 for linux and x86_64                                                                    \n                    Installing \'gh\'...                                                                                                                           \n[12/10/22 04:16:23] Downloading \'gh\' to /tmp/gh_2.20.2_linux_amd64.tar.gz (size: 9.6 MB)                                                                         \nDownloading... ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00\n[12/10/22 04:16:27] Unpacking /tmp/gh_2.20.2_linux_amd64.tar.gz to /tmp/gh_2.20.2_linux_amd64.tar                                                                \n                    Copying /tmp/gh_2.20.2_linux_amd64.tar/gh_2.20.2_linux_amd64/bin/gh to /home/yuvalgold/.mercado/gh                                           \n👍       \'gh\' version v2.20.2 is installed\n```\n\n\n```bash\n$ mercado is-latest docker\n\n👍       You have the latest version of \'docker\' (20.10.21)\n```\n\n\n```bash\n$ mercado show minikube\n\nName: minikube\nInstalled: ✅\nLocal Version: 1.27.1\nPath: /home/yuvalgold/.mercado/minikube\nRemote Version: v1.28.0\n```\n\n\n```bash\n$ mercado list --label k8s --with-labels\n\n                   Mercado tools                   \n┏━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━┓\n┃ Name     ┃ Labels                   ┃ Installed ┃\n┡━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━┩\n│ helm     │ k8s                      │ ❌        │\n│ k3d      │ k8s,docker,orchestration │ ❌        │\n│ kind     │ k8s,docker,orchestration │ ✅        │\n│ kubectl  │ k8s                      │ ✅        │\n│ minikube │ k8s,orchestration        │ ✅        │\n└──────────┴──────────────────────────┴───────────┘\n```\n\n\n```bash\n$ mercado list --installed-only --verbose\n\n                                       Mercado tools                                       \n┏━━━━━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓\n┃ Name      ┃ Vendor     ┃ Installed                                                      ┃\n┡━━━━━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩\n│ compose   │ GitHub     │ ✅ (/home/yuvalgold/.docker/cli-plugins/docker-compose 2.13.0) │\n│ gh        │ GitHub     │ ✅ (/home/yuvalgold/.mercado/gh 2.20.2)                        │\n│ kind      │ GitHub     │ ✅ (/home/yuvalgold/.mercado/kind 0.17.0)                      │\n│ minikube  │ GitHub     │ ✅ (/home/yuvalgold/.mercado/minikube 1.27.1)                  │\n├───────────┼────────────┼────────────────────────────────────────────────────────────────┤\n│ consul    │ Hashicorp  │ ✅ (/usr/local/bin/consul 1.13.1)                              │\n│ terraform │ Hashicorp  │ ✅ (/home/yuvalgold/.mercado/terraform 1.3.3)                  │\n│ vagrant   │ Hashicorp  │ ✅ (/home/yuvalgold/.mercado/vagrant 2.3.2)                    │\n│ vault     │ Hashicorp  │ ✅ (/home/yuvalgold/.mercado/vault 1.12.1)                     │\n├───────────┼────────────┼────────────────────────────────────────────────────────────────┤\n│ kubectl   │ URLFetcher │ ✅ (/home/yuvalgold/.mercado/kubectl 1.25.3)                   │\n├───────────┼────────────┼────────────────────────────────────────────────────────────────┤\n│ docker    │ Shell      │ ✅ (/usr/bin/docker 20.10.21)                                  │\n└───────────┴────────────┴────────────────────────────────────────────────────────────────┘\n```\n\n<!-- [[[end]]] -->\n\n## Contribute\n\n<!-- [[[cog\nimport cog\nfrom textwrap import dedent\nimport subprocess\n\ndef print_command(command):\n    cog.outl(dedent(f"""\n```bash\n$ {command}\n\n{subprocess.getoutput(command)}\n```\n    """))\n\nprint_command("TERM=\'\' make -s help")\n]]] -->\n\n```bash\n$ TERM=\'\' make -s help\n\n\nUsage:\n  make <target>\n\ncode\n  verify                run all verifications\n  test                  run tests\n  format                run formatter\n  lint                  run linter\n\nartifact\n  install               install package locally\n  dist                  generate package artifacts\n  docs                  generate documentation\n  deploy                deploy Python package to PyPI\n\ngeneral\n  clean                 clean environment\n\n```\n\n<!-- [[[end]]] -->\n\n## Test\n\nThe tests are running with pytest inside of a docker-compose container\n\n```bash\nmake test\n\n# Run a specific test file with TEST=</path/to/file>\nTEST=./tests/test_github.py make test\n\n# Run a tests matching an expression TEST_FUNC=<expression>\nTEST_FUNC="invalid" make test\n\n# Add more verbose logs\nLOGLEVEL=debug make test\n```\n\n### Run locally\n\n```bash\npoetry run mercado --help\n```\n\n### Install dist locally\n\n```bash\nmake install\n\nmercado --help\n```\n\n### Run GHA\n\nI use [nektos/act](https://github.com/nektos/act) tool to run the Git Hub Action locally.\nBy default, act runs on a slim container image, for docker-compose usage the base image is replaced.\n\n```bash\nact --platform=ubuntu-latest=lucasalt/act_base:latest -j <JOB>\n```\n\n## Generate docs\n\n1. Install dist locally\n1. Run inside virtualenv\n\n```bash\nmake docs\n```\n',
    'author': 'YuviGold',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/YuviGold/mercado',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
