# 刮削攻略


## 配置qBittorrent下载后执行torcp进行刮削
* 参考 [利用 qBittorrent 的完成后自动执行脚本功能实现入库](qb自动入库.md) 配置qBittorrent下载完成后执行 `rcp.sh` 进行刮削和上传
* qBittorrent的 'Torrent完成时运行外部程序' / 'Run after completion' 中填写命令：
```sh
/home/ccf2012/torcp/rcp.sh  "%F" "%N" "%G"
```
* 下面给出一些 `rcp.sh` 示例，供参考

### 上传gd盘，用于Plex, 不收原盘
```sh 
#!/bin/bash
python3 /home/ccf2012/torcp/tp.py "$1" -d "/home/ccf2012/emby/$2/" -s  --imdbid "$3" --tmdb-api-key your_tmdb_api_key --tmdb-lang en-US --lang cn,ja,ko --plex-bracket --make-log >>/home/ccf2012/rcp.log 2>>/home/ccf2012/rcp_error.log

rclone copy "/home/ccf2012/emby/$2/"  gd:/media/emby/
rm -rf "/home/ccf2012/emby/$2/"
```
> * 刮削结果放入媒本文件夹后，仍需要Plex/Emby重新作识别，通过加 `--plex-bracket` 或 `--emby-bracket` 以生成指定TMDb id的目录名，将会减少麻烦
> * Plex的刮削，对于中文和数字混合的文件夹名易错，如果没有加上述 bracket 加以确定，则建议以 `--tmdb-lang en-US` 进行生成文件名
> * 如果电影和剧集能够分开下载，可以对电影使用 `--origin-name`，而对于剧集使用原名，Plex在识别各集时容易出现问题
> * 为防止刮削改名后无法追溯原文件名，可加 `--make-log` 以记录来源
> 

### 本地作硬链，用于Emby，原盘抽出m2ts
```sh
python3 /downloads/torcp/tp.py "$1" -d "/downloads/emby/" -s --imdb "$3" --extract-bdmv --make-log --tmdb-origin-name  --emby-bracket --filename-emby-bracket --tmdb-api-key your_tmdb_api_key  >> /downloads/rcp.log 2>>/downloads/rcp_error.log
```
> * 如果你的qbit是在docker中，则需要参考这里的文档注意配置 [qBit以docker安装](qb%E8%87%AA%E5%8A%A8%E5%85%A5%E5%BA%93.md#3-qbit%E4%BB%A5docker%E5%AE%89%E8%A3%85)
> * `--tmdb-origin-name` 选项将生成类似 '至暴之年 (2014) [tmdbid=241239] - 1080p.BluRay.x265.10bit.DTS_ADE.mkv' 这样的文件名，即前面是文件夹名后面是原名的后半部分；这样的命名可以在易于刮削的情况下保留尽可能多的信息，特别地，在实用中至少需要DV, HDR等信息，在Emby中可以作为版本名称用于选择；
> * Emby在处理电影时，如果文件夹内有多个版本的媒体文件，则需要这些媒体文件的前缀都与目录相同，才会形成一个海报内多个版本，所以方案是加 `--filename-emby-bracket` 选项，这个选项仅对电影有效
> * 上面各种命名生成选项对于使用 `--extract-bdmv` 抽取原盘都是无效的。 `--extract-bdmv` 选项会将包含BDMV目录的原盘电影或剧集中，较大的 .m2ts 文件抽取出来，组成可供 Emby 读取的形式。
>   * 对于只有一个 .m2ts 文件的电影，将会改名为 '电影文件夹名 - 00002.m2ts' 其中0002为 BDMV/STREAM 目录下的原名
>   * 有多个大尺寸 .m2ts 文件的电影，其中 BDMV/STREAM 目录下的多个 .m2ts 文件将会被分别链出，这样在Emby中会变成版本名
>   * 原盘剧集类，则是形成 '剧集文件夹名 S01E01 - 盘文件夹名_00002.m2ts' 这样的文件名，其中的E01, E02 是按文件名排序，顺序生成，是一种尽力猜测；



## 在添加下载器时指定媒体资源IMDb
1. 可以使用 [种子列表过滤油猴脚本](https://github.com/ccf-2012/torfilter) 实现在pt站上浏览时添加下载，如果在种子列表页或详情页中，能取得种子的IMDb，则在 qBittorrent 中添加种子时，会同时添加IMDb标签，此标签在执行上述 `rcp.sh` 时将会被 torcp 应用。
   * 如果未能取得IMDb，整个流程仍能继续完成，将会使用种子名称进行解析，并到TMDb中查询通过猜测来确定媒体资源。
2. 当前[最新版 PT Plugin Plus](https://github.com/pt-plugins/PT-Plugin-Plus) (dev分支)，在配置qBittorrent下载器时，可以设置“发送种子时自动添加IMDb标签”。致谢PTPP的开发者们！

* 参考[配合 PTPP 与torcc 实现 Emby/Plex 自动入库流程](AutoPlex.md)


## 还是可能会出现的问题
* 开始下载后，关注 `rcp_error.log`，如果刮削或上传中出现错误，会在 `rcp_error.log` 文件中记录
* 有可能rclone上传出错
* 有可能连接TMDb时出错
* 有种巡的PT站，通常有准确的IMDb信息，对于电影，已经可以完整准确地走完全流程。然而剧集还是会出问题：
  1. 剧集的第二季及后面的季，在各PT站上有不同的处理方式，有的站会标第1季的IMDb，有的会标第二季第1集的IMDb，此时在TMDb中可能会搜不到，这时年份也对不上，因此会仅用名字搜索，可能搜不到，或搜到错误的剧集上去。
  2. 未标IMDb的剧集，也同样，只能凭名字和年份搜索。剧集搜索时只有第一季年份才有意义，其它季的年份用来搜索会更明确地导致错误。
  3. 也会存在IMDb标错的情况


## rclone上传出错
* 如果rclone上传出错，在rcp_error.log中通常可以发现记录，此时可以到下载器所在机器 shell 中手工运行 `rcp.sh` 完成重刮重传，如：
```sh
./rcp.sh /home/ccf2012/Downloads/The.Green.Prince.2014.1080p.BluRay.DTS.x264-HDS The.Green.Prince.2014.1080p.BluRay.DTS.x264-HDS tt2304915
```
* 其中第1个参数是媒体文件位置；第2个参数是用于在/home/ccf2012/emby目录下生成硬链的暂存位置，可以为任何不重复的名字；第3个参数是指定资源的IMDb，若不加则依赖名字猜测


## 无IMDb信息时的刮削错误
* 大量国产剧在各pt站中没有设置IMDb，而文件名中没有'S01'字样，甚至没有年份，此时容易产生刮削错误。可以手工指定TMDb id来确定媒体进行刮削：
1. 建一个`rcptmdb.sh`，同容与上面 `rcp.sh` 差别仅在于使用TMDb指定媒体，如：
```sh 
#!/bin/bash
python3 /home/ccf2012/torcp/tp.py "$1" -d "/home/ccf2012/emby/$2/" -s  --tmdbid "$3" --tmdb-api-key your_tmdb_api_key --tmdb-lang en-US --lang cn,ja,ko --plex-bracket --make-log >>/home/ccf2012/rcp.log 2>>/home/ccf2012/rcp_error.log
... 余同
``` 

2. 手工在 [TMDb网站](http://themoviedb.org/) 中搜索该剧，找到正确的TMDb id

3. 手动重刮重传，命令与上面类似，注意TMDb需指定movie/tv，如：
```sh
./rcptmdb.sh /home/ccf2012/Downloads/Threesome.2018.WEB-DL.1080p.H264.2Audio.AAC-HDSWEB Threesome.2018.WEB-DL.1080p.H264.2Audio.AAC-HDSWEB tv108458
```

## 传到TMDbNotFound中的媒体
* 如果媒体未被识别，并被rclone上传到gd盘中的 TMDbNotFound 目录中，可以在mount了gd盘的机器上，手工指定 IMDb id 或 TMDb id，在gd盘上进行`--move-run` 移动并改名媒体到合适目录，如：
```sh
python3 tp.py "/gd/emby/TMDbNotFound/龙纹身的女孩.The.Girl.with.the.Dragon.Tattoo.2009" -s --tmdbid m15472 -d /gd124/media/148/emby/   --plex-bracket --tmdb-api-key your_tmdb_api_key  --tmdb-lang en-US --lang cn,ja,ko  --move-run 
```


## Plex媒体识别错误检查
### 同一媒体包含多个媒体目录内容检查
1. 在 Plex 运行的机器上，使用 [PlexMove](https://github.com/ccf-2012/plexmove) 列出一个Section中各条目所包含的Location
```sh
python3 plexmv.py --ls-section 电影 > movies.txt
```
* 如此可得到各电影或剧集的存储位置

2. 以支持正则查找的编辑器（如Sublime Text, VS Code)打开上述 movies.txt，以正则搜索：
```re
0 (>> [^(]*\().*\n\s*1 (?!\1)
```
* 若在vim中则
```re
: g/0 \(>> [^(]*(\).*\n\s*1 \(\1\)\@!
```

以上正则搜索会找到媒体有多个Location，且1和2不同的，例如：
```
1964: 发条橙
  0 >> /gd/emby/Movie/other/A Clockwork Orange (1971)/A Clockwork Orange (1971) - 1080p_ADE.mkv
  1 >> /gd/emby/Movie/other/发条橙 (1971)/发条橙 (1971) - 2160p_BeiTai.mkv
```
3. 此时可自行采取措施，合并或删除多余的


### 媒体存储位置的目录数与Plex库中条目数对不上
1. 列出在Plex机器上媒体目录数
```sh
ls /gd/emby/Movie/other > moviels.txt
```

2. 以前面取得的媒体位置文件，如movies.txt，在其中筛出location并排序
```sh
cat movies.txt |  sed -n "s/^.*Movie\/other\/\([^\/]*\)\/.*$/\1/p" | sort > movieloc.txt
```

3. 使用vimdiff对比
```sh
vimdiff movieloc.txt moviels.txt
```

## Multi Part型的电影
* 像”战争与和平“ 这样的multi part类型的电影，只能手工处理，而且Plex的支持似乎只是将它们连成了一个长电影
* 参考[Plex 命名规则](https://support.plex.tv/articles/naming-and-organizing-your-movie-media-files/)

