#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("source-map-support/register");
const cdk = require("@aws-cdk/core");
const sqs_redrive_1 = require("../lib/sqs-redrive");
const aws_sqs_1 = require("@aws-cdk/aws-sqs");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'test-stack');
let mainQueue = new aws_sqs_1.Queue(stack, 'main-queue');
let deadLetterQueue = new aws_sqs_1.Queue(stack, 'dlq-queue');
new sqs_redrive_1.SqsRedrive(stack, 'SqsRedriveConstructStack', {
    mainQueue: mainQueue,
    deadLetterQueue: deadLetterQueue
});
new sqs_redrive_1.SqsRedrive(stack, 'SqsRedriveConstructStack2', {
    mainQueue: mainQueue,
    deadLetterQueue: deadLetterQueue
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLXJlZHJpdmUtY29uc3RydWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3FzLXJlZHJpdmUtY29uc3RydWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHVDQUFxQztBQUNyQyxxQ0FBcUM7QUFDckMsb0RBQThDO0FBQzlDLDhDQUF1QztBQUV2QyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBRS9DLElBQUksU0FBUyxHQUFHLElBQUksZUFBSyxDQUFDLEtBQUssRUFBRSxZQUFZLENBQUMsQ0FBQztBQUMvQyxJQUFJLGVBQWUsR0FBRyxJQUFJLGVBQUssQ0FBQyxLQUFLLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFFcEQsSUFBSSx3QkFBVSxDQUFDLEtBQUssRUFBRSwwQkFBMEIsRUFBRTtJQUM5QyxTQUFTLEVBQUUsU0FBUztJQUNwQixlQUFlLEVBQUUsZUFBZTtDQUNuQyxDQUFDLENBQUM7QUFFSCxJQUFJLHdCQUFVLENBQUMsS0FBSyxFQUFFLDJCQUEyQixFQUFFO0lBQy9DLFNBQVMsRUFBRSxTQUFTO0lBQ3BCLGVBQWUsRUFBRSxlQUFlO0NBQ25DLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiMhL3Vzci9iaW4vZW52IG5vZGVcbmltcG9ydCAnc291cmNlLW1hcC1zdXBwb3J0L3JlZ2lzdGVyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7U3FzUmVkcml2ZX0gZnJvbSAnLi4vbGliL3Nxcy1yZWRyaXZlJztcbmltcG9ydCB7UXVldWV9IGZyb20gXCJAYXdzLWNkay9hd3Mtc3FzXCI7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAndGVzdC1zdGFjaycpO1xuXG5sZXQgbWFpblF1ZXVlID0gbmV3IFF1ZXVlKHN0YWNrLCAnbWFpbi1xdWV1ZScpO1xubGV0IGRlYWRMZXR0ZXJRdWV1ZSA9IG5ldyBRdWV1ZShzdGFjaywgJ2RscS1xdWV1ZScpO1xuXG5uZXcgU3FzUmVkcml2ZShzdGFjaywgJ1Nxc1JlZHJpdmVDb25zdHJ1Y3RTdGFjaycsIHtcbiAgICBtYWluUXVldWU6IG1haW5RdWV1ZSxcbiAgICBkZWFkTGV0dGVyUXVldWU6IGRlYWRMZXR0ZXJRdWV1ZVxufSk7XG5cbm5ldyBTcXNSZWRyaXZlKHN0YWNrLCAnU3FzUmVkcml2ZUNvbnN0cnVjdFN0YWNrMicsIHtcbiAgICBtYWluUXVldWU6IG1haW5RdWV1ZSxcbiAgICBkZWFkTGV0dGVyUXVldWU6IGRlYWRMZXR0ZXJRdWV1ZVxufSk7XG4iXX0=